/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.api;

import cn.vertxup.rbac.domain.tables.daos.SViewDao;
import cn.vertxup.rbac.domain.tables.pojos.SAction;
import cn.vertxup.rbac.service.accredit.ActionStub;
import cn.vertxup.rbac.service.view.PersonalStub;
import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.cv.em.OwnerType;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.Envelop;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import javax.inject.Inject;

@Queue
public class ViewPersonalActor {
    @Inject
    private transient PersonalStub personalStub;
    @Inject
    private transient ActionStub actionStub;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-VIEW-P/ADD")
    public Future<JsonObject> pViewCreate(Envelop envelop) {
        return this.pAction(envelop).compose(action -> {
            JsonObject data = Ux.getJson((Envelop)envelop);
            String userId = envelop.userId();
            JsonObject normalized = data.copy();
            normalized.put("user", (Object)userId);
            normalized.mergeIn(envelop.headersX());
            normalized.put("resourceId", (Object)action.getResourceId());
            normalized.put("owner", (Object)userId);
            normalized.put("ownerType", (Object)OwnerType.USER.name());
            return this.personalStub.create(normalized).compose(Ux::futureJ);
        });
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-VIEW-P/DELETE")
    public Future<Boolean> pViewDelete(String key) {
        HashSet<String> keys = new HashSet<String>();
        keys.add(key);
        return this.personalStub.delete(keys);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-VIEW-P/GET/BY-USER")
    public Future<JsonArray> pViewByUser(Envelop envelop) {
        return this.pAction(envelop).compose(action -> {
            if (Objects.isNull(action)) {
                return Ux.futureA();
            }
            JsonObject data = Ux.getJson((Envelop)envelop);
            String userId = envelop.userId();
            return this.personalStub.byUser(action.getResourceId(), userId, data.getString("position")).compose(Ux::futureA).compose(Ut.ifJArray((String[])new String[]{"criteria", "projection", "rows"}));
        });
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-VIEW-P/EXISTING")
    public Future<Boolean> pViewExisting(Envelop envelop) {
        return this.pAction(envelop).compose(action -> {
            if (Objects.isNull(action)) {
                return Future.succeededFuture((Object)Boolean.FALSE);
            }
            JsonObject data = Ux.getJson((Envelop)envelop);
            String userId = envelop.userId();
            JsonObject criteria = new JsonObject();
            criteria.mergeIn(data.copy());
            criteria.remove("uri");
            criteria.remove("method");
            criteria.put("owner", (Object)userId);
            criteria.put("ownerType", (Object)OwnerType.USER.name());
            return Ux.Jooq.on(SViewDao.class).existAsync(criteria);
        });
    }

    private Future<SAction> pAction(Envelop envelop) {
        JsonObject header = envelop.headersX();
        String sigma = header.getString("sigma");
        JsonObject data = Ux.getJson((Envelop)envelop);
        String uri = data.getString("uri");
        HttpMethod method = HttpMethod.valueOf((String)data.getString("method"));
        return this.actionStub.fetchAction(uri, method, sigma);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-VIEW-P/GET/BY-ID")
    public Future<JsonObject> pViewById(String key) {
        return this.personalStub.byId(key).compose(Ux::futureJ).compose(Ut.ifJObject((String[])new String[]{"criteria", "projection", "rows"}));
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-VIEW-P/UPDATE")
    public Future<JsonObject> pViewUpdate(Envelop envelop) {
        String key = Ux.getString((Envelop)envelop);
        JsonObject data = Ux.getJson1((Envelop)envelop);
        String userId = envelop.userId();
        data.put("user", (Object)userId);
        return this.personalStub.update(key, data).compose(Ux::futureJ).compose(Ut.ifJObject((String[])new String[]{"criteria", "projection", "rows"}));
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-VIEW-P/BATCH/DELETE")
    public Future<Boolean> pViewsDelete(JsonArray keys) {
        return this.personalStub.delete(Ut.toSet((JsonArray)keys));
    }
}

