/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.accredit;

import cn.vertxup.rbac.domain.tables.pojos.SResource;
import cn.vertxup.rbac.domain.tables.pojos.SView;
import cn.vertxup.rbac.service.accredit.MatrixStub;
import cn.vertxup.rbac.service.view.ViewStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.atom.ScConfig;
import io.vertx.tp.rbac.init.ScPin;
import io.vertx.tp.rbac.logged.ScResource;
import io.vertx.tp.rbac.logged.ScUser;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.atom.secure.Vis;
import io.vertx.up.commune.secure.DataBound;
import io.vertx.up.uca.cache.Rapid;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class MatrixService
implements MatrixStub {
    @Inject
    private transient ViewStub stub;

    @Override
    public Future<DataBound> fetchBound(ScUser user, ScResource request) {
        ScConfig config = ScPin.getConfig();
        return Rapid.t((String)config.getPoolResource()).read((Object)request.key()).compose(data -> {
            SResource resource = (SResource)Ux.fromJson((JsonObject)data.getJsonObject("record"), SResource.class);
            return this.fetchViews(user, resource, request.view()).compose(this::toBound).compose(bound -> {
                Boolean virtual = resource.getVirtual();
                if (Objects.nonNull(virtual) && virtual.booleanValue()) {
                    JsonObject seeker = new JsonObject();
                    seeker.put("config", (Object)Ut.toJObject((String)resource.getSeekConfig()));
                    seeker.put("syntax", (Object)Ut.toJObject((String)resource.getSeekSyntax()));
                    seeker.put("component", (Object)resource.getSeekComponent());
                    bound.addSeeker(seeker);
                }
                return Ux.future((Object)bound);
            });
        });
    }

    private Future<List<SView>> fetchViews(ScUser user, SResource resource, Vis view) {
        String userId = user.user();
        return this.stub.fetchMatrix(userId, resource.getKey(), view).compose(viewData -> {
            if (Objects.isNull(viewData)) {
                String profileName = Sc.valueProfile(resource);
                return user.roles(profileName).compose(roles -> this.stub.fetchMatrix((JsonArray)roles, resource.getKey(), view));
            }
            return this.toResult((SView)viewData);
        });
    }

    private Future<List<SView>> toResult(SView entity) {
        ArrayList<SView> matrixList = new ArrayList<SView>();
        matrixList.add(entity);
        return Future.succeededFuture(matrixList);
    }

    private Future<DataBound> toBound(List<SView> matrices) {
        DataBound bound = new DataBound();
        matrices.forEach(matrix -> {
            JsonObject viewData = (JsonObject)Ut.serializeJson((Object)matrix);
            bound.addProjection(matrix.getProjection()).addRows(matrix.getRows()).addCriteria(matrix.getCriteria()).addView(viewData);
        });
        return Future.succeededFuture((Object)bound);
    }
}

