/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.business;

import cn.vertxup.rbac.domain.tables.pojos.SUser;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.business.ExEmployee;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.atom.unity.UObject;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import java.util.function.Function;

class UserHelper {
    private static final Annal LOGGER = Annal.get(UserHelper.class);

    UserHelper() {
    }

    static Future<JsonObject> fetchEmployee(SUser user) {
        return UserHelper.applyTunnel(user, executor -> executor.fetchAsync(user.getModelKey()));
    }

    static Future<JsonObject> updateEmployee(SUser user, JsonObject params) {
        return UserHelper.applyTunnel(user, executor -> executor.updateAsync(params.getString("employeeId"), params));
    }

    private static Future<JsonObject> applyUser(SUser user) {
        return Ux.future((Object)user).compose(Ux::futureJ);
    }

    private static Future<JsonObject> applyTunnel(SUser user, Function<ExEmployee, Future<JsonObject>> fnTunnel) {
        if (Objects.nonNull(user)) {
            if (Objects.nonNull(user.getModelKey())) {
                return Ke.channelAsync(ExEmployee.class, () -> {
                    Sc.infoAuth(LOGGER, "Employee empty workflow executing Executor", new Object[0]);
                    return UserHelper.applyUser(user);
                }, executor -> {
                    Sc.infoAuth(LOGGER, "Fetch employee information by id = {0}", user.getModelKey());
                    return ((Future)fnTunnel.apply((ExEmployee)executor)).compose(employee -> Objects.isNull(employee) ? Ux.future((Object)new JsonObject()) : Ux.future((Object)employee)).compose(employee -> UObject.create((JsonObject)Ux.toJson((Object)user).copy()).append(employee).convert("modelKey", "employeeId").toFuture());
                });
            }
            Sc.infoAuth(LOGGER, "Employee empty workflow executing Model Key", new Object[0]);
            return UserHelper.applyUser(user);
        }
        Sc.infoAuth(LOGGER, "Employee empty workflow executing Null", new Object[0]);
        return Ux.future((Object)new JsonObject());
    }
}

