/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.login;

import cn.vertxup.rbac.service.login.CodeStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._401CodeExpiredException;
import io.vertx.tp.error._401CodeWrongException;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.atom.unity.UObject;
import io.vertx.up.unity.Ux;
import java.util.Objects;

public class CodeService
implements CodeStub {
    @Override
    public Future<JsonObject> authorize(String clientId) {
        String authCode = Sc.valueCode();
        JsonObject response = new JsonObject();
        return Sc.cacheCode(clientId, authCode).compose(item -> UObject.create((JsonObject)response).append("code", item).toFuture());
    }

    @Override
    public Future<String> verify(String clientId, String code) {
        return Sc.cacheCode(clientId).compose(item -> {
            if (Objects.isNull(item)) {
                return Ux.thenError(_401CodeExpiredException.class, (Object[])new Object[]{this.getClass(), clientId, code});
            }
            if (!code.equals(item)) {
                return Ux.thenError(_401CodeWrongException.class, (Object[])new Object[]{this.getClass(), code});
            }
            return Ux.future((Object)clientId);
        });
    }
}

