/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.login;

import cn.vertxup.rbac.domain.tables.daos.OAccessTokenDao;
import cn.vertxup.rbac.domain.tables.daos.SUserDao;
import cn.vertxup.rbac.service.business.UserStub;
import cn.vertxup.rbac.service.login.LoginStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._401PasswordWrongException;
import io.vertx.tp.error._423UserDisabledException;
import io.vertx.tp.error._449UserNotFoundException;
import io.vertx.tp.rbac.logged.ScUser;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.atom.unity.UObject;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import javax.inject.Inject;

public class LoginService
implements LoginStub {
    private static final Annal LOGGER = Annal.get(LoginService.class);
    @Inject
    private transient UserStub userStub;

    @Override
    public Future<JsonObject> execute(String username, String password) {
        return Sc.lockVerify(username, () -> Ux.Jooq.on(SUserDao.class).fetchOneAsync("username", (Object)username).compose(fetched -> {
            Boolean isLock;
            if (Objects.isNull(fetched)) {
                Sc.warnAuth(LOGGER, "[ \u0391\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 ] username = {0} does not exist.", username);
                return Ux.thenError(_449UserNotFoundException.class, (Object[])new Object[]{this.getClass(), username});
            }
            Boolean bl = isLock = Objects.isNull(fetched.getActive()) ? Boolean.FALSE : fetched.getActive();
            if (!isLock.booleanValue()) {
                Sc.warnAuth(LOGGER, "[ \u0391\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 ] username = {0} has been locked / disabled", username);
                return Ux.thenError(_423UserDisabledException.class, (Object[])new Object[]{this.getClass(), username});
            }
            if (Objects.isNull(password) || !password.equals(fetched.getPassword())) {
                Sc.warnAuth(LOGGER, "[ \u0391\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 ] username = {0}, the password ( {1} ) you provided is wrong.", username);
                return Sc.lockOn(username).compose(nil -> Ux.thenError(_401PasswordWrongException.class, (Object[])new Object[]{this.getClass(), username}));
            }
            Sc.infoAudit(LOGGER, "[ \u0391\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 ] User ( username = {0} ) login successfully.", username);
            return Sc.lockOff(username).compose(nil -> Ux.future((Object)fetched));
        }).compose(user -> this.userStub.fetchOUser(user.getKey()).compose(Ux::futureJ).compose(ouserJson -> {
            JsonObject userJson = (JsonObject)Ut.serializeJson((Object)user);
            JsonObject merged = Ut.elementAppend((JsonObject)userJson, (JsonObject[])new JsonObject[]{ouserJson});
            return UObject.create((JsonObject)merged).pickup(new String[]{"key", "scope", "state", "clientSecret", "grantType"}).denull().toFuture();
        }).compose(response -> {
            String initPwd = Sc.valuePassword();
            if (initPwd.equals(user.getPassword())) {
                response.put("password", (Object)false);
            }
            return Ux.future((Object)response);
        })));
    }

    @Override
    public Future<Boolean> logout(String token, String habitus) {
        return Ux.Jooq.on(OAccessTokenDao.class).deleteByAsync(new JsonObject().put("token", (Object)token)).compose(nil -> ScUser.logout(habitus));
    }
}

