/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.view;

import cn.vertxup.rbac.domain.tables.daos.SViewDao;
import cn.vertxup.rbac.domain.tables.pojos.SView;
import cn.vertxup.rbac.service.view.PersonalStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.cv.em.OwnerType;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class PersonalService
implements PersonalStub {
    @Override
    public Future<List<SView>> byUser(String resourceId, String ownerId, String position) {
        JsonObject criteria = Ux.whereAnd();
        criteria.put("ownerType", (Object)OwnerType.USER.name());
        criteria.put("owner", (Object)ownerId);
        criteria.put("resourceId", (Object)resourceId);
        criteria.put("position", (Object)(Objects.isNull(position) ? "DEFAULT" : position));
        return Ux.Jooq.on(SViewDao.class).fetchAsync(criteria);
    }

    @Override
    public Future<SView> create(JsonObject data) {
        Ut.ifString((JsonObject)data, (String[])new String[]{"criteria", "projection", "rows"});
        SView view = (SView)Ut.deserialize((JsonObject)data, SView.class);
        if (data.containsKey("user")) {
            view.setCreatedBy(data.getString("user"));
            view.setUpdatedBy(data.getString("user"));
        }
        view.setCreatedAt(LocalDateTime.now());
        view.setUpdatedAt(LocalDateTime.now());
        view.setKey(UUID.randomUUID().toString());
        view.setActive(Boolean.TRUE);
        return Ux.Jooq.on(SViewDao.class).insertAsync((Object)view);
    }

    @Override
    public Future<Boolean> delete(Set<String> keys) {
        if (1 == keys.size()) {
            String key = keys.iterator().next();
            return Ux.Jooq.on(SViewDao.class).deleteByIdAsync((Object)key);
        }
        JsonObject criteria = Ux.whereKeys(keys);
        return Ux.Jooq.on(SViewDao.class).deleteByAsync(criteria);
    }

    @Override
    public Future<SView> byId(String key) {
        return Ux.Jooq.on(SViewDao.class).fetchByIdAsync((Object)key);
    }

    @Override
    public Future<SView> update(String key, JsonObject data) {
        return this.byId(key).compose(view -> {
            if (Objects.isNull(view)) {
                return Ux.future();
            }
            JsonObject serialized = (JsonObject)Ut.serializeJson((Object)view);
            Ut.ifString((JsonObject)data, (String[])new String[]{"criteria", "projection", "rows"});
            if (data.containsKey("user")) {
                view.setUpdatedBy(data.getString("user"));
                view.setUpdatedAt(LocalDateTime.now());
            }
            serialized.mergeIn(data, true);
            return Ux.Jooq.on(SViewDao.class).updateAsync(serialized);
        });
    }
}

