/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.view;

import cn.vertxup.rbac.domain.tables.daos.SViewDao;
import cn.vertxup.rbac.domain.tables.pojos.SView;
import cn.vertxup.rbac.service.view.ViewStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.cv.em.OwnerType;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.atom.secure.Vis;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class ViewService
implements ViewStub {
    private static final Annal LOGGER = Annal.get(ViewService.class);

    @Override
    public Future<SView> fetchMatrix(String userId, String resourceId, Vis view) {
        JsonObject filters = this.toFilters(resourceId, view);
        filters.put("owner", (Object)userId);
        filters.put("ownerType", (Object)OwnerType.USER.name());
        Sc.infoResource(LOGGER, "My View Operation: {0}, filters = {1}", "fetch", filters.encode());
        return Ux.Jooq.on(SViewDao.class).fetchOneAsync(new JsonObject().put("criteria", (Object)filters));
    }

    @Override
    public Future<JsonObject> saveMatrix(String userId, JsonObject viewData, JsonArray projection, JsonObject criteria) {
        String resourceId = viewData.getString("resourceId");
        Vis view = Vis.smart((Object)viewData.getValue("view"));
        JsonObject filters = this.toFilters(resourceId, view);
        filters.put("owner", (Object)userId);
        filters.put("ownerType", (Object)OwnerType.USER.name());
        Sc.infoResource(LOGGER, "My View Operation: {0}, filters = {1}", "save", filters.encode());
        return Ux.Jooq.on(SViewDao.class).fetchOneAsync(filters).compose(queried -> {
            SView myView;
            if (Objects.isNull(queried)) {
                JsonObject data = filters.copy().mergeIn(viewData);
                data.put("key", (Object)UUID.randomUUID().toString());
                data.put("active", (Object)Boolean.TRUE);
                data.put("rows", (Object)new JsonObject().encode());
                myView = (SView)Ut.deserialize((JsonObject)data, SView.class);
                myView.setCreatedAt(LocalDateTime.now());
                myView.setCreatedBy(userId);
            } else {
                myView = queried;
            }
            if (Ut.notNil((JsonArray)projection)) {
                myView.setProjection(projection.encode());
            }
            if (Objects.nonNull(criteria)) {
                myView.setCriteria(criteria.encode());
            } else {
                myView.setCriteria(new JsonObject().encode());
            }
            myView.setUpdatedAt(LocalDateTime.now());
            myView.setUpdatedBy(userId);
            if (Objects.isNull(queried)) {
                return Ux.Jooq.on(SViewDao.class).insertAsync((Object)myView);
            }
            return Ux.Jooq.on(SViewDao.class).updateAsync((Object)myView);
        }).compose(upsert -> {
            JsonObject cached = new JsonObject();
            cached.put("projection", (Object)Ut.toJArray((String)upsert.getProjection()));
            cached.put("criteria", (Object)Ut.toJObject((String)upsert.getCriteria()));
            return Ux.future((Object)cached);
        });
    }

    @Override
    public Future<List<SView>> fetchMatrix(JsonArray roleIds, String resourceId, Vis view) {
        JsonObject filters = this.toFilters(resourceId, view);
        filters.put("owner,i", (Object)roleIds);
        filters.put("ownerType", (Object)OwnerType.ROLE.name());
        return Ux.Jooq.on(SViewDao.class).fetchAndAsync(new JsonObject().put("criteria", (Object)filters));
    }

    private JsonObject toFilters(String resourceId, Vis view) {
        JsonObject filters = new JsonObject();
        filters.put("", (Object)Boolean.TRUE);
        filters.put("resourceId", (Object)resourceId);
        filters.put("name", (Object)view.view());
        filters.put("position", (Object)view.position());
        return filters;
    }
}

