/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.wall.authorization;

import cn.vertxup.rbac.wall.authorization.ProfileAuthorization;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.exception.web._403ForbiddenException;
import io.vertx.up.fn.Fn;
import io.vertx.up.secure.authorization.AuthorizationResource;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ProfileResource
implements AuthorizationResource {
    private final transient Aegis aegis;

    private ProfileResource(Aegis aegis) {
        this.aegis = aegis;
    }

    public static AuthorizationResource create(Aegis aegis) {
        return new ProfileResource(aegis);
    }

    public void requestResource(RoutingContext context, Handler<AsyncResult<Authorization>> handler) {
        JsonObject params = AuthorizationResource.parameters((RoutingContext)context);
        Method method = this.aegis.getAuthorizer().getResource();
        Fn.safeJvm(() -> {
            Future future = (Future)method.invoke(this.aegis.getProxy(), params);
            future.onComplete(res -> {
                if (res.succeeded()) {
                    if (Objects.isNull(res.result())) {
                        handler.handle((Object)Future.failedFuture((Throwable)new _403ForbiddenException(this.getClass())));
                    } else {
                        ConcurrentHashMap<String, Set<String>> profiles = new ConcurrentHashMap<String, Set<String>>();
                        Ut.itJObject((JsonObject)((JsonObject)res.result()), (values, field) -> profiles.put((String)field, Ut.toSet((JsonArray)values)));
                        ProfileAuthorization required = ProfileAuthorization.create(profiles);
                        handler.handle((Object)Future.succeededFuture((Object)required));
                    }
                } else {
                    Throwable ex = res.cause();
                    handler.handle((Object)Future.failedFuture((Throwable)ex));
                }
            });
        });
    }
}

