/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.secure;

import cn.vertxup.rbac.wall.authorization.ProfileProvider;
import cn.vertxup.rbac.wall.authorization.ProfileResource;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.secure.AegisItem;
import io.vertx.up.eon.em.AuthWall;
import io.vertx.up.secure.LeeBuiltIn;
import io.vertx.up.secure.LeeExtension;
import io.vertx.up.secure.authorization.AuthorizationBuiltInHandler;
import io.vertx.up.secure.authorization.AuthorizationResource;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;

public class WallExtension
implements LeeExtension {
    public AuthenticationHandler authenticate(Vertx vertx, Aegis config) {
        LeeBuiltIn internal = (LeeBuiltIn)Ut.service(LeeBuiltIn.class);
        Aegis copy = config.copy();
        copy.setType(AuthWall.JWT);
        return internal.authenticate(vertx, copy);
    }

    public AuthorizationHandler authorization(Vertx vertx, Aegis config) {
        AuthorizationResource resource = ProfileResource.create(config);
        AuthorizationBuiltInHandler handler = AuthorizationBuiltInHandler.create((AuthorizationResource)resource);
        AuthorizationProvider provider = ProfileProvider.provider(config);
        handler.addAuthorizationProvider(provider);
        return handler;
    }

    public String encode(JsonObject data, AegisItem config) {
        return Ux.Jwt.token((JsonObject)data);
    }

    public JsonObject decode(String token, AegisItem config) {
        return Ux.Jwt.extract((String)token);
    }
}

