/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.atom.acl;

import cn.vertxup.rbac.domain.tables.pojos.SVisitant;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.atom.acl.AclItem;
import io.vertx.tp.rbac.atom.acl.AclMap;
import io.vertx.tp.rbac.cv.em.AclType;
import io.vertx.up.commune.secure.Acl;
import io.vertx.up.commune.secure.AclView;
import io.vertx.up.eon.em.AclPhase;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AclData
implements Acl {
    private final Set<String> fields = new TreeSet<String>();
    private final ConcurrentMap<String, AclView> commonMap = new ConcurrentHashMap<String, AclView>();
    private final ConcurrentMap<AclType, ConcurrentMap<String, AclView>> complexMap = new ConcurrentHashMap<AclType, ConcurrentMap<String, AclView>>(){
        {
            this.put(AclType.DATA, new ConcurrentHashMap());
            this.put(AclType.REFERENCE, new ConcurrentHashMap());
        }
    };
    private final ConcurrentMap<String, JsonObject> dependMap = new ConcurrentHashMap<String, JsonObject>();
    private final ConcurrentMap<String, AclType> complexType = new ConcurrentHashMap<String, AclType>();
    private final AclPhase phase;
    private final JsonObject config = new JsonObject();

    public AclData(SVisitant visitant) {
        if (Objects.nonNull(visitant)) {
            Ut.itJObject((JsonObject)Ut.toJObject((String)visitant.getAclVerge()), (config, field) -> this.dependMap.put((String)field, (JsonObject)config));
            Set visibleSet = Ut.toSet((JsonArray)Ut.toJArray((String)visitant.getAclVisible()));
            Set viewSet = Ut.toSet((JsonArray)Ut.toJArray((String)visitant.getAclView()));
            visibleSet.forEach(field -> {
                boolean view = viewSet.contains(field);
                AclItem simple = new AclItem((String)field, view, true);
                simple.depend(this.dependMap.containsKey(field));
                this.commonMap.put((String)field, simple);
            });
            JsonObject varietyJson = Ut.toJObject((String)visitant.getAclVariety());
            this.initComplex(varietyJson, AclType.DATA, viewSet);
            JsonObject vowJson = Ut.toJObject((String)visitant.getAclVow());
            this.initComplex(vowJson, AclType.REFERENCE, viewSet);
            this.phase = (AclPhase)Ut.toEnum(visitant::getPhase, AclPhase.class, (Enum)AclPhase.EAGER);
        } else {
            this.phase = AclPhase.ERROR;
        }
    }

    private void initComplex(JsonObject input, AclType type, Set<String> viewSet) {
        Ut.itJObject((JsonObject)input, (config, field) -> {
            boolean view = viewSet.contains(field);
            AclMap complex = new AclMap((String)field, view, (JsonObject)config);
            complex.depend(this.dependMap.containsKey(field));
            this.complexType.put((String)field, type);
            ((ConcurrentMap)this.complexMap.get((Object)type)).put(field, complex);
        });
    }

    public Set<String> aclVisible() {
        return this.commonMap.keySet();
    }

    public AclPhase phase() {
        return this.phase;
    }

    public void bind(JsonObject record) {
        if (Ut.notNil((JsonObject)record)) {
            this.fields.addAll(record.fieldNames());
        }
    }

    public Acl config(JsonObject config) {
        if (Ut.notNil((JsonObject)config)) {
            this.config.mergeIn(config);
        }
        return this;
    }

    public JsonObject config() {
        return this.config;
    }

    public JsonObject acl() {
        JsonObject acl = new JsonObject();
        JsonArray access = new JsonArray();
        JsonArray edition = new JsonArray();
        this.commonMap.forEach((field, aclField) -> {
            if (aclField.isAccess()) {
                access.add(field);
            }
            if (aclField.isEdit()) {
                edition.add(field);
            }
        });
        if (Ut.notNil((JsonArray)access)) {
            acl.put("access", (Object)access);
        }
        if (Ut.notNil((JsonArray)edition) && Ut.isNil((JsonObject)this.config)) {
            acl.put("edition", (Object)edition);
        }
        if (Ut.isNil((JsonObject)this.config)) {
            Set accessArr = Ut.toSet((JsonArray)access.copy());
            accessArr.addAll(this.fields);
            acl.put("fields", (Object)Ut.toJArray((Set)accessArr));
        }
        return acl;
    }
}

