/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.authorization.child;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.authorization.Align;
import io.vertx.tp.rbac.authorization.Amalgam;
import io.vertx.tp.rbac.authorization.Assembler;
import io.vertx.tp.rbac.authorization.ScDetent;
import io.vertx.tp.rbac.logged.ProfileGroup;
import io.vertx.tp.rbac.logged.ProfileRole;
import io.vertx.tp.rbac.logged.ProfileType;
import java.util.List;

public class GcCritical
implements ScDetent {
    private final transient List<ProfileGroup> original;

    public GcCritical(List<ProfileGroup> original) {
        this.original = original;
    }

    private List<ProfileRole> before(List<ProfileRole> profiles) {
        ProfileGroup eager = Align.eager(this.original);
        List<ProfileRole> source = Amalgam.children(profiles, eager);
        return Amalgam.eager(source);
    }

    @Override
    public JsonObject proc(List<ProfileRole> profiles) {
        JsonObject group = new JsonObject();
        List<ProfileRole> source = this.before(profiles);
        Amalgam.logGroup(this.getClass(), source);
        Assembler.union(ProfileType.CHILD_CRITICAL_UNION, source).accept(group);
        Assembler.eager(ProfileType.CHILD_CRITICAL_EAGER, source).accept(group);
        Assembler.lazy(ProfileType.CHILD_CRITICAL_LAZY, source).accept(group);
        Assembler.intersect(ProfileType.CHILD_CRITICAL_INTERSECT, source).accept(group);
        return group;
    }
}

