/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.authorization.parent;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.authorization.Align;
import io.vertx.tp.rbac.authorization.Amalgam;
import io.vertx.tp.rbac.authorization.Assembler;
import io.vertx.tp.rbac.authorization.ScDetent;
import io.vertx.tp.rbac.logged.ProfileGroup;
import io.vertx.tp.rbac.logged.ProfileRole;
import io.vertx.tp.rbac.logged.ProfileType;
import java.util.List;

public class GpOverlook
implements ScDetent {
    private final transient List<ProfileGroup> original;

    public GpOverlook(List<ProfileGroup> original) {
        this.original = original;
    }

    private List<ProfileRole> before(List<ProfileRole> profiles) {
        ProfileGroup lazy = Align.lazy(this.original);
        List<ProfileRole> source = Amalgam.parent(profiles, lazy);
        return Amalgam.lazy(source);
    }

    @Override
    public JsonObject proc(List<ProfileRole> profiles) {
        JsonObject group = new JsonObject();
        List<ProfileRole> source = this.before(profiles);
        Amalgam.logGroup(this.getClass(), source);
        Assembler.union(ProfileType.PARENT_OVERLOOK_UNION, source).accept(group);
        Assembler.eager(ProfileType.PARENT_OVERLOOK_EAGER, source).accept(group);
        Assembler.lazy(ProfileType.PARENT_OVERLOOK_LAZY, source).accept(group);
        Assembler.intersect(ProfileType.PARENT_OVERLOOK_INTERSECT, source).accept(group);
        return group;
    }
}

