/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.extension;

import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.commune.Envelop;
import io.vertx.up.extension.PlugAuditor;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroAnno;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.Instant;
import java.util.Objects;

public class AuditorPin
implements PlugAuditor {
    private static final Annal LOGGER = Annal.get(AuditorPin.class);
    private final transient JsonObject config = new JsonObject();

    public PlugAuditor bind(JsonObject config) {
        if (Ut.notNil((JsonObject)config)) {
            this.config.mergeIn(config);
        }
        return this;
    }

    public Future<Envelop> audit(RoutingContext context, Envelop envelop) {
        HttpServerRequest request = context.request();
        if (this.isValid(request)) {
            HttpMethod method = request.method();
            String userId = envelop.userId();
            Instant instant = Instant.now();
            if (HttpMethod.POST == method) {
                envelop.value("createdBy", (Object)userId);
                envelop.value("createdAt", (Object)instant);
                envelop.value("updatedBy", (Object)userId);
                envelop.value("updatedAt", (Object)instant);
                Sc.infoAudit(LOGGER, "Full auditing: userId = `{0}`, at = `{1}`", userId, instant.toString());
            } else {
                envelop.value("updatedBy", (Object)userId);
                envelop.value("updatedAt", (Object)instant);
                Sc.infoAudit(LOGGER, "Update auditing: userId = `{0}`, at = `{1}`", userId, instant.toString());
            }
        } else {
            Sc.debugAuth(LOGGER, "Do not match: {0}", request.path());
        }
        return Ux.future((Object)envelop);
    }

    private boolean isValid(HttpServerRequest request) {
        JsonArray include = this.config.getJsonArray("include");
        if (Objects.isNull(include) || include.isEmpty()) {
            return false;
        }
        HttpMethod method = request.method();
        if (HttpMethod.PUT != method && HttpMethod.POST != method) {
            return false;
        }
        String path = request.path();
        long counter = include.stream().filter(Objects::nonNull).map(item -> (String)item).filter(path::startsWith).count();
        JsonArray exclude = this.config.getJsonArray("exclude");
        String recovery = ZeroAnno.recoveryUri((String)request.path(), (HttpMethod)request.method());
        if (Objects.isNull(exclude) || exclude.isEmpty()) {
            return 0L < counter;
        }
        long except = exclude.stream().filter(Objects::nonNull).map(item -> (String)item).filter(recovery::startsWith).count();
        return 0L < counter && except <= 0L;
    }
}

