/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.logged;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.tp.rbac.authorization.Align;
import io.vertx.tp.rbac.authorization.ScDetent;
import io.vertx.tp.rbac.logged.ProfileGroup;
import io.vertx.tp.rbac.logged.ProfileRole;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.atom.Refer;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.cache.Rapid;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ScUser {
    private static final Annal LOGGER = Annal.get(ScUser.class);
    private static final ConcurrentMap<String, ScUser> USERS = new ConcurrentHashMap<String, ScUser>();
    private final transient Rapid<String, JsonObject> rapid;
    private final transient String habitus;
    private transient String userId;

    private ScUser(String habitus) {
        this.habitus = habitus;
        this.rapid = Rapid.t((String)"ZERO-CACHE-HABITUS");
    }

    private static Future<JsonObject> initRoles(JsonObject profile, JsonArray roles) {
        Sc.infoAuth(LOGGER, "Roles : {0}", roles.encode());
        ArrayList futures = new ArrayList();
        roles.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).map(ProfileRole::new).map(ProfileRole::initAsync).forEach(futures::add);
        return CompositeFuture.join(futures).compose(Sc::composite).compose(ScDetent.user(profile)::procAsync);
    }

    private static Future<JsonObject> initGroups(JsonObject profile, JsonArray groups) {
        Sc.debugAuth(LOGGER, "Groups: {0}", groups.encode());
        ArrayList futures = new ArrayList();
        groups.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).map(ProfileGroup::new).map(ProfileGroup::initAsync).forEach(futures::add);
        Refer parentHod = new Refer();
        Refer childHod = new Refer();
        return CompositeFuture.join(futures).compose(Sc::composite).compose(profiles -> Ux.future((Object)profiles).compose(Align::flat).compose(ScDetent.group(profile)::procAsync).compose(nil -> Ux.future((Object)profiles)).compose(Align::parent).compose(arg_0 -> ((Refer)parentHod).future(arg_0)).compose(parents -> ScDetent.parent(profile, profiles).procAsync((List<ProfileRole>)parents)).compose(nil -> ScDetent.inherit(profile, profiles).procAsync((List)parentHod.get())).compose(nil -> Ux.future((Object)profiles)).compose(Align::children).compose(arg_0 -> ((Refer)childHod).future(arg_0)).compose(children -> ScDetent.children(profile, profiles).procAsync((List<ProfileRole>)children)).compose(nil -> ScDetent.extend(profile, profiles).procAsync((List)childHod.get())).compose(nil -> Ux.future((Object)profiles))).compose(nil -> Ux.future((Object)profile));
    }

    public static Future<ScUser> login(JsonObject data) {
        String habitus = data.getString("habitus");
        return Ux.future((Object)((ScUser)Fn.pool(USERS, (Object)habitus, () -> new ScUser(habitus)))).compose(user -> {
            JsonObject stored = data.copy();
            stored.remove("habitus");
            String userId = stored.getString("user");
            return user.user(userId).set(stored);
        }).compose(user -> user.profile().compose(profile -> ScUser.initRoles(profile, data.getJsonArray("role"))).compose(profile -> ScUser.initGroups(profile, data.getJsonArray("group"))).compose(user::profile).compose(user::report).compose(nil -> Ux.future((Object)user)));
    }

    public static ScUser login(String habitus) {
        return (ScUser)USERS.get(habitus);
    }

    public static ScUser login(User user) {
        JsonObject principle = user.principal();
        String habitus = principle.getString("habitus");
        return ScUser.login(habitus);
    }

    public static Future<Boolean> logout(String habitus) {
        ScUser user = (ScUser)USERS.get(habitus);
        Objects.requireNonNull(user);
        return user.logout();
    }

    private ScUser user(String userId) {
        this.userId = userId;
        return this;
    }

    public String user() {
        return this.userId;
    }

    public Future<JsonObject> view() {
        return this.get("view").compose(Ut::ifJNil);
    }

    public Future<JsonObject> view(String viewKey) {
        return this.view().compose(view -> Ux.future((Object)view.getJsonObject(viewKey))).compose(view -> {
            if (Ut.notNil((JsonObject)view)) {
                Sc.infoAuth(LOGGER, "ScUser \u001b[0;37m----> Cache key = {0}, Data = {1}\u001b[m.", viewKey, view.encode());
            }
            return Ux.future((Object)view);
        });
    }

    public Future<JsonObject> view(String viewKey, JsonObject viewData) {
        return this.view().compose(view -> {
            JsonObject stored = view.getJsonObject(viewKey, new JsonObject());
            stored.mergeIn(viewData);
            view.put(viewKey, (Object)stored);
            return this.set("view", view);
        });
    }

    public Future<JsonObject> profile() {
        return this.get("profile").compose(Ut::ifJNil);
    }

    public Future<JsonObject> permissions() {
        return this.profile("PERM");
    }

    public Future<JsonObject> roles() {
        return this.profile("ROLE");
    }

    public Future<JsonArray> roles(String profileName) {
        return this.profile("ROLE").compose(json -> {
            Sc.infoAuth(LOGGER, "Profile Name: {0}", profileName);
            return Ux.future((Object)json.getJsonArray(profileName, new JsonArray()));
        });
    }

    public Future<JsonObject> profile(JsonObject profileData) {
        return this.set("profile", profileData);
    }

    private Future<JsonObject> profile(String key) {
        return this.profile().compose(profile -> {
            JsonObject map = new JsonObject();
            Ut.itJObject((JsonObject)profile, (item, profileName) -> {
                JsonArray data = item.getJsonArray(key, new JsonArray());
                map.put(profileName, (Object)data);
            });
            return Ux.future((Object)map);
        });
    }

    private Future<Boolean> logout() {
        USERS.remove(this.habitus);
        return this.rapid.clear((Object)this.habitus).compose(nil -> Ux.future((Object)Boolean.TRUE));
    }

    private Future<JsonObject> report(JsonObject result) {
        Sc.infoAuth(LOGGER, "Permissions: {0}", result.encode());
        return Ux.future((Object)result);
    }

    private Future<ScUser> set(JsonObject data) {
        return this.getStored().compose(stored -> {
            stored.mergeIn(data, true);
            return this.rapid.write((Object)this.habitus, stored).compose(nil -> Ux.future((Object)this));
        });
    }

    private <T> Future<T> set(String dataKey, T value) {
        return this.getStored().compose(stored -> {
            stored.put(dataKey, value);
            return this.rapid.write((Object)this.habitus, stored).compose(nil -> Ux.future((Object)value));
        });
    }

    private Future<JsonObject> getStored() {
        return this.rapid.read((Object)this.habitus).compose(stored -> {
            if (Ut.isNil((JsonObject)stored)) {
                stored = new JsonObject();
            }
            return Ux.future((Object)stored);
        });
    }

    private <T> Future<T> get(String dataKey) {
        return this.getStored().compose(stored -> {
            if (Ut.isNil((JsonObject)stored)) {
                return Ux.future();
            }
            return Ux.future((Object)stored.getValue(dataKey));
        });
    }
}

