/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.refine;

import cn.vertxup.rbac.domain.tables.pojos.SResource;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._401ImageCodeWrongException;
import io.vertx.tp.error._401MaximumTimesException;
import io.vertx.tp.rbac.atom.ScConfig;
import io.vertx.tp.rbac.init.ScPin;
import io.vertx.tp.rbac.refine.ScImage;
import io.vertx.tp.rbac.refine.ScLog;
import io.vertx.up.exception.web._501NotSupportException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.cache.Rapid;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

class ScTool {
    private static final Annal LOGGER = Annal.get(ScTool.class);
    private static final ScConfig CONFIG = ScPin.getConfig();

    ScTool() {
    }

    static String valueCode() {
        Integer codeLength = CONFIG.getCodeLength();
        String authCode = Ut.randomString((int)codeLength);
        ScLog.infoAuth(LOGGER, "Generated Authorization Code: {0}", authCode);
        return authCode;
    }

    static String valuePassword() {
        return CONFIG.getPasswordInit();
    }

    static String valueProfile(SResource resource) {
        String modeRole = resource.getModeRole();
        String modeGroup = resource.getModeGroup();
        if (Ut.isNil((String)modeGroup)) {
            return "USER_" + modeRole.toUpperCase(Locale.getDefault());
        }
        String modeTree = resource.getModeTree();
        String group = modeGroup.toUpperCase(Locale.getDefault()) + "_" + modeRole.toUpperCase(Locale.getDefault());
        if (Ut.isNil((String)modeTree)) {
            return group;
        }
        return modeTree.toUpperCase(Locale.getDefault()) + "_" + group;
    }

    static <V> Future<V> code(String key) {
        String codePool = CONFIG.getPoolCode();
        return Rapid.t((String)codePool).clear((Object)key);
    }

    static <V> Future<V> code(String key, V value) {
        String codePool = CONFIG.getPoolCode();
        Integer codeExpired = CONFIG.getCodeExpired();
        return Rapid.t((String)codePool, (int)codeExpired).write((Object)key, value);
    }

    static <T> Future<T> imageVerify(String sessionId, JsonObject params, Function<JsonObject, Future<T>> executor) {
        Boolean support = CONFIG.getVerifyCode();
        if (Objects.nonNull(support) && support.booleanValue()) {
            Fn.out((boolean)Objects.isNull(sessionId), _501NotSupportException.class, (Object[])new Object[]{ScTool.class});
            String imageCode = params.getString("captcha");
            if (Objects.isNull(imageCode)) {
                return Ux.thenError(_401ImageCodeWrongException.class, (Object[])new Object[]{ScTool.class, null});
            }
            String imagePool = CONFIG.getPoolVerify();
            Rapid rapid = Rapid.t((String)imagePool);
            return rapid.read((Object)sessionId).compose(stored -> {
                if (Objects.isNull(stored)) {
                    return Ux.thenError(_401ImageCodeWrongException.class, (Object[])new Object[]{ScTool.class, imageCode});
                }
                if (stored.equalsIgnoreCase(imageCode)) {
                    JsonObject processed = params.copy();
                    processed.remove("captcha");
                    return rapid.clear((Object)sessionId).compose(nil -> (Future)executor.apply(processed));
                }
                return Ux.thenError(_401ImageCodeWrongException.class, (Object[])new Object[]{ScTool.class, imageCode});
            });
        }
        return executor.apply(params);
    }

    static Future<Buffer> imageOn(String sessionId, Integer width, Integer height) {
        Boolean support = CONFIG.getVerifyCode();
        if (Objects.nonNull(support) && support.booleanValue()) {
            String imagePool = CONFIG.getPoolVerify();
            String code = Ut.randomString((int)5);
            return Rapid.t((String)imagePool, (int)300).write((Object)sessionId, (Object)code).compose(codeImage -> ScImage.imageGenerate(codeImage, width, height));
        }
        return Ux.thenError(_501NotSupportException.class, (Object[])new Object[]{ScTool.class});
    }

    static Future<Boolean> imageKo(String sessionId) {
        Boolean support = CONFIG.getVerifyCode();
        if (Objects.nonNull(support) && support.booleanValue()) {
            String imagePool = CONFIG.getPoolVerify();
            return Rapid.t((String)imagePool).clear((Object)sessionId).compose(nil -> Ux.futureT());
        }
        return Ux.thenError(_501NotSupportException.class, (Object[])new Object[]{ScTool.class});
    }

    static Future<JsonObject> lockVerify(String username, Supplier<Future<JsonObject>> executor) {
        Integer limitation = CONFIG.getVerifyLimitation();
        if (Objects.isNull(limitation)) {
            return executor.get();
        }
        String codeLimitation = CONFIG.getPoolLimitation();
        return Rapid.t((String)codeLimitation).read((Object)username).compose(counter -> {
            if (Objects.isNull(counter)) {
                return (Future)executor.get();
            }
            if (counter < limitation) {
                return (Future)executor.get();
            }
            Integer verifyDuration = CONFIG.getVerifyDuration();
            return Ux.thenError(_401MaximumTimesException.class, (Object[])new Object[]{ScTool.class, limitation, verifyDuration});
        });
    }

    static Future<Integer> lockOn(String username) {
        Integer limitation = CONFIG.getVerifyLimitation();
        if (Objects.isNull(limitation)) {
            return Ux.future();
        }
        String codeLimitation = CONFIG.getPoolLimitation();
        Integer verifyDuration = CONFIG.getVerifyDuration();
        Rapid rapid = Rapid.t((String)codeLimitation, (int)verifyDuration);
        return rapid.read((Object)username).compose(counter -> {
            if (Objects.isNull(counter)) {
                return rapid.write((Object)username, (Object)1);
            }
            return rapid.write((Object)username, (Object)(counter + 1));
        });
    }

    static <V> Future<V> lockOff(String username) {
        Integer limitation = CONFIG.getVerifyLimitation();
        if (Objects.isNull(limitation)) {
            return Ux.future();
        }
        String codeLimitation = CONFIG.getPoolLimitation();
        return Rapid.t((String)codeLimitation).clear((Object)username);
    }
}

