/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.api;

import cn.vertxup.rbac.domain.tables.daos.RRolePermDao;
import cn.vertxup.rbac.domain.tables.pojos.SPermSet;
import cn.vertxup.rbac.service.business.PermGStub;
import cn.vertxup.rbac.service.business.PermStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.config.XHeader;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import javax.inject.Inject;

@Queue
public class PermActor {
    @Inject
    private transient PermStub stub;
    @Inject
    private transient PermGStub setStub;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PERMISSION/GROUP")
    public Future<JsonArray> calculate(XHeader header) {
        return this.setStub.fetchAsync(header.getSigma());
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PERMISSION/DEFINITION/SAVING")
    public Future<JsonObject> saveDefinition(JsonObject processed, XHeader header, User user) {
        String sigma = header.getSigma();
        Sc.infoWeb(this.getClass(), "Permission Update: {0}, sigma = {1}", processed.encode(), sigma);
        JsonArray permissions = Ut.valueJArray((JsonArray)processed.getJsonArray("data"));
        String group = processed.getString("group");
        String type = processed.getString("type");
        JsonArray removed = Ut.valueJArray((JsonArray)processed.getJsonArray("removed"));
        JsonObject relation = Ut.valueJObject((JsonObject)processed.getJsonObject("relation"));
        String userKey = Ux.keyUser((User)user);
        SPermSet permSet = new SPermSet();
        permSet.setName(group);
        permSet.setType(type);
        permSet.setActive(Boolean.TRUE);
        permSet.setSigma(sigma);
        permSet.setLanguage(header.getLanguage());
        permSet.setUpdatedAt(LocalDateTime.now());
        permSet.setUpdatedBy(userKey);
        return this.setStub.saveDefinition(permissions, permSet).compose(nil -> this.stub.syncAsync(removed, relation, userKey)).compose(nil -> Ux.future((Object)relation));
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PERMISSION/BY/ROLE")
    public Future<JsonArray> fetchAsync(String roleId) {
        return (Future)Fn.getEmpty((Object)Ux.futureA(), () -> Ux.Jooq.on(RRolePermDao.class).fetchAsync("roleId", (Object)roleId).compose(Ux::futureA), (String[])new String[]{roleId});
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PERMISSION/SAVING")
    public Future<JsonArray> savePerm(String roleId, JsonArray permissions) {
        return this.stub.syncAsync(permissions, roleId);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PERMISSION/UN-READY")
    public Future<JsonObject> searchUnReady(JsonObject query, XHeader header) {
        return this.stub.searchAsync(query, header.getSigma());
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PERMISSION/CRUD/READ")
    public Future<JsonObject> fetch(String key) {
        return this.stub.fetchAsync(key);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PERMISSION/CRUD/CREATE")
    public Future<JsonObject> add(JsonObject body) {
        return this.stub.createAsync(body);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PERMISSION/CRUD/UPDATE")
    public Future<JsonObject> edit(String key, JsonObject body) {
        return this.stub.updateAsync(key, body);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0391\u03c3\u03c6\u03ac\u03bb\u03b5\u03b9\u03b1/X-PERMISSION/CRUD/DELETE")
    public Future<Boolean> delete(String key, User user) {
        String userKey = Ux.keyUser((User)user);
        return this.stub.deleteAsync(key, userKey);
    }
}

