/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.business;

import cn.vertxup.rbac.domain.tables.daos.SActionDao;
import cn.vertxup.rbac.domain.tables.daos.SResourceDao;
import cn.vertxup.rbac.domain.tables.pojos.SAction;
import cn.vertxup.rbac.domain.tables.pojos.SResource;
import cn.vertxup.rbac.service.business.ResourceStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Optional;
import java.util.UUID;

public class ResourceService
implements ResourceStub {
    @Override
    public Future<JsonObject> fetchResource(String resourceId) {
        return Ux.Jooq.on(SResourceDao.class).fetchByIdAsync((Object)resourceId).compose(Ux::futureJ).compose(resource -> Ux.Jooq.on(SActionDao.class).fetchOneAsync("resourceId", (Object)resourceId).compose(Ux::futureJ).compose(action -> Ux.future((Object)resource.put("action", action))));
    }

    @Override
    public Future<JsonObject> createResource(JsonObject params) {
        SResource sResource = (SResource)Ux.fromJson((JsonObject)params, SResource.class);
        return Ux.Jooq.on(SResourceDao.class).insertAsync((Object)sResource).compose(Ux::futureJ).compose(resource -> {
            if (params.containsKey("action") && Ut.notNil((JsonObject)params.getJsonObject("action"))) {
                SAction sAction = (SAction)Ux.fromJson((JsonObject)params.getJsonObject("action"), SAction.class);
                sAction.setKey(Optional.ofNullable(sAction.getKey()).orElse(UUID.randomUUID().toString())).setActive(Optional.ofNullable(sAction.getActive()).orElse(Boolean.TRUE)).setResourceId(Optional.ofNullable(sAction.getResourceId()).orElse(resource.getString("key"))).setLevel(Optional.ofNullable(sAction.getLevel()).orElse(resource.getInteger("level"))).setSigma(Optional.ofNullable(sAction.getSigma()).orElse(resource.getString("sigma"))).setLanguage(Optional.ofNullable(sAction.getLanguage()).orElse(resource.getString("language")));
                return Ux.Jooq.on(SActionDao.class).insertAsync((Object)sAction).compose(Ux::futureJ).compose(action -> Ux.future((Object)resource.put("action", action)));
            }
            return Ux.future((Object)resource);
        });
    }

    @Override
    public Future<JsonObject> updateResource(String resourceId, JsonObject params) {
        SResource sResource = (SResource)Ux.fromJson((JsonObject)params, SResource.class);
        return Ux.Jooq.on(SResourceDao.class).upsertAsync((Object)resourceId, (Object)sResource).compose(Ux::futureJ).compose(resource -> {
            if (params.containsKey("action") && Ut.notNil((JsonObject)params.getJsonObject("action"))) {
                SAction sAction = (SAction)Ux.fromJson((JsonObject)params.getJsonObject("action"), SAction.class);
                return Ux.Jooq.on(SActionDao.class).upsertAsync(new JsonObject().put("resourceId", (Object)resourceId), (Object)sAction).compose(Ux::futureJ).compose(action -> Ux.future((Object)resource.put("action", action)));
            }
            return Ux.future((Object)resource);
        });
    }

    @Override
    public Future<Boolean> deleteResource(String resourceId) {
        return Ux.Jooq.on(SActionDao.class).deleteByAsync(new JsonObject().put("resourceId", (Object)resourceId)).compose(result -> Ux.Jooq.on(SResourceDao.class).deleteByIdAsync((Object)resourceId));
    }
}

