/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.wall.authorization;

import cn.vertxup.rbac.wall.authorization.ProfileAuthorization;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationContext;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class ProfileAuthorizationImpl
implements ProfileAuthorization {
    private final ConcurrentMap<String, Set<String>> permissionMap = new ConcurrentHashMap<String, Set<String>>();

    ProfileAuthorizationImpl(ConcurrentMap<String, Set<String>> permissionMap) {
        Objects.requireNonNull(permissionMap);
        this.permissionMap.putAll(permissionMap);
    }

    @Override
    public ConcurrentMap<String, Set<String>> permissions() {
        return this.permissionMap;
    }

    @Override
    public Set<String> permissions(String profile) {
        return this.permissionMap.getOrDefault(profile, new HashSet());
    }

    public boolean match(AuthorizationContext context) {
        Objects.requireNonNull(context);
        User user = context.user();
        if (user != null) {
            ProfileAuthorization resolved = ProfileAuthorization.create(this.permissionMap);
            for (String providerId : user.authorizations().getProviderIds()) {
                for (Authorization authorization : user.authorizations().get(providerId)) {
                    if (!authorization.verify((Authorization)resolved)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean verify(Authorization otherAuthorization) {
        Objects.requireNonNull(otherAuthorization);
        if (otherAuthorization instanceof ProfileAuthorization) {
            ProfileAuthorization profileAuthorization = (ProfileAuthorization)otherAuthorization;
            Set checked = profileAuthorization.permissions().keySet().stream().map(profileName -> {
                Set<String> resourcePerms = profileAuthorization.permissions((String)profileName);
                Set userPerms = this.permissionMap.getOrDefault(profileName, new HashSet());
                return userPerms.containsAll(resourcePerms);
            }).collect(Collectors.toSet());
            return checked.stream().anyMatch(item -> item);
        }
        return false;
    }
}

