/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.logged;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.logged.ProfileRole;
import io.vertx.tp.rbac.refine.Sc;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ProfileGroup
implements Serializable {
    private final transient String groupId;
    private final transient Integer priority;
    private final transient JsonArray role;
    private final transient List<ProfileRole> roles = new ArrayList<ProfileRole>();
    private transient String reference;

    public ProfileGroup(JsonObject data) {
        this.groupId = data.getString("groupId");
        this.priority = data.getInteger("priority");
        this.role = null == data.getJsonArray("role") ? new JsonArray() : data.getJsonArray("role");
    }

    Future<ProfileGroup> initAsync() {
        return this.fetchProfilesAsync().compose(profiles -> {
            this.setRoles((List<ProfileRole>)profiles);
            return Future.succeededFuture((Object)this);
        });
    }

    public ProfileGroup init() {
        this.setRoles(this.fetchProfiles());
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getKey() {
        return this.groupId;
    }

    public List<ProfileRole> getRoles() {
        return this.roles;
    }

    private void setRoles(List<ProfileRole> profiles) {
        this.roles.clear();
        this.roles.addAll(profiles);
    }

    public String getReference() {
        return this.reference;
    }

    public ProfileGroup setReference(String reference) {
        this.reference = reference;
        return this;
    }

    private Future<List<ProfileRole>> fetchProfilesAsync() {
        ArrayList futures = new ArrayList();
        this.role.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).map(ProfileRole::new).map(ProfileRole::initAsync).forEach(futures::add);
        return CompositeFuture.join(futures).compose(Sc::composite).compose(profiles -> {
            profiles.forEach(profile -> profile.setGroup(this));
            return Future.succeededFuture((Object)profiles);
        });
    }

    private List<ProfileRole> fetchProfiles() {
        return this.role.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).map(ProfileRole::new).map(ProfileRole::init).map(role -> role.setGroup(this)).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileGroup)) {
            return false;
        }
        ProfileGroup that = (ProfileGroup)o;
        return this.groupId.equals(that.groupId);
    }

    public int hashCode() {
        return Objects.hash(this.groupId);
    }

    public String toString() {
        return "ProfileGroup{groupId='" + this.groupId + "', priority=" + this.priority + ", role=" + this.role + ", reference='" + this.reference + "'}";
    }
}

