/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.logged;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.atom.ScConfig;
import io.vertx.tp.rbac.init.ScPin;
import io.vertx.tp.rbac.logged.ProfileGroup;
import io.vertx.tp.rbac.logged.ScRole;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;

public class ProfileRole
implements Serializable {
    private static final ScConfig CONFIG = ScPin.getConfig();
    private final transient Integer priority;
    private final transient ScRole role;
    private transient ProfileGroup reference;

    public ProfileRole(JsonObject data) {
        String roleId = data.getString("roleId");
        this.role = ScRole.login(roleId);
        this.priority = data.getInteger("priority");
    }

    Future<ProfileRole> initAsync() {
        boolean isSecondary = CONFIG.getSupportSecondary();
        return isSecondary ? this.role.fetchWithCache().compose(ids -> Future.succeededFuture((Object)this)) : this.role.fetch().compose(ids -> Future.succeededFuture((Object)this));
    }

    public ProfileRole init() {
        this.role.refresh();
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getKey() {
        return this.role.key();
    }

    public Set<String> getAuthorities() {
        return this.role.authorities();
    }

    public ProfileGroup getGroup() {
        return this.reference;
    }

    public ProfileRole setGroup(ProfileGroup reference) {
        this.reference = reference;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileRole that = (ProfileRole)o;
        return this.role.equals(that.role);
    }

    public int hashCode() {
        return Objects.hash(this.role);
    }

    public String toString() {
        return "ProfileRole{priority=" + this.priority + ", role=" + this.role + ", reference=" + this.reference + "}";
    }
}

