/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.commune.secure.Acl;
import io.vertx.up.eon.em.AclPhase;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

class ScAcl {
    ScAcl() {
    }

    static void aclRecord(JsonObject record, Acl acl) {
        if (Objects.nonNull(acl)) {
            acl.bind(record);
        }
    }

    static JsonArray aclOn(JsonArray original, Acl acl) {
        return ScAcl.aclProjection(original, acl, out -> AclPhase.EAGER == out.phase());
    }

    private static JsonArray aclProjection(JsonArray original, Acl acl, Predicate<Acl> predicate) {
        JsonArray projection = Ut.valueJArray((JsonArray)original);
        if (Objects.isNull(acl)) {
            return projection;
        }
        if (predicate.test(acl)) {
            return ScAcl.aclProjection(original, acl);
        }
        return projection;
    }

    private static JsonArray aclProjection(JsonArray original, Acl acl) {
        Set aclProjection = acl.aclVisible();
        if (aclProjection.isEmpty()) {
            return original;
        }
        HashSet replaced = new HashSet(aclProjection);
        Ut.itJArray((JsonArray)original, String.class, (field, index) -> {
            if (aclProjection.contains(field)) {
                replaced.add(field);
            }
        });
        return Ut.toJArray(replaced);
    }
}

