/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.refine;

import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Random;
import javax.imageio.ImageIO;

class ScImage {
    private static final Random RANDOM = new Random();
    private static final Font FONT_DEFAULT = new Font("Times New Roman", 0, 18);
    private static final Font FONT_TEXT = new Font("Fixedsys", 1, 28);

    ScImage() {
    }

    static Future<Buffer> imageGenerate(String code, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics graphics = image.getGraphics();
        graphics.fillRect(0, 0, width, height);
        graphics.setFont(FONT_DEFAULT);
        graphics.setColor(ScImage.colorRandom(160, 200));
        for (int i = 1; i <= 100; ++i) {
            ScImage.drawLine(graphics, width, height);
        }
        ScImage.drawText(graphics, code);
        return (Future)Fn.getJvm(() -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            return Ux.future((Object)Buffer.buffer((byte[])baos.toByteArray()));
        }, (Object[])new Object[0]);
    }

    private static void drawText(Graphics graphics, String code) {
        for (int i = 0; i < code.length(); ++i) {
            graphics.setFont(FONT_TEXT);
            graphics.setColor(new Color(RANDOM.nextInt(101), RANDOM.nextInt(111), RANDOM.nextInt(121)));
            graphics.translate(RANDOM.nextInt(3), RANDOM.nextInt(3));
            graphics.drawString(String.valueOf(code.charAt(i)), 30 + 28 * i, 24);
        }
    }

    private static void drawLine(Graphics graphics, int width, int height) {
        int x = RANDOM.nextInt(width);
        int y = RANDOM.nextInt(height);
        int xl = RANDOM.nextInt(13);
        int yl = RANDOM.nextInt(15);
        graphics.drawLine(x, y, x + xl, y + yl);
    }

    private static Color colorRandom(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + RANDOM.nextInt(bc - fc - 16);
        int g = fc + RANDOM.nextInt(bc - fc - 14);
        int b = fc + RANDOM.nextInt(bc - fc - 18);
        return new Color(r, g, b);
    }
}

