/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.redis;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.auth.PRNG;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.tp.error._409SessionVersionException;
import io.vertx.tp.plugin.redis.RedisClientStub;
import io.vertx.tp.plugin.redis.RedisExtra;
import io.vertx.tp.plugin.redis.RedisSession;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Vector;

public class RedisStore
implements SessionStore {
    private static final Annal LOGGER = Annal.get(RedisStore.class);
    private static final String MAP_NAME = "vertx-web.sessions";
    private static transient PRNG random;
    private final transient List<String> sessionIds = new Vector<String>();
    private transient RedisClient client;
    private transient LocalMap<String, Session> localMap;
    private transient RedisExtra extra;

    public SessionStore init(Vertx vertx, JsonObject options) {
        random = new PRNG(vertx);
        this.localMap = vertx.sharedData().getLocalMap(MAP_NAME);
        RedisOptions opts = new RedisOptions(options);
        LOGGER.info("[ ZERO ] ( Redis ) Connect to Endpoint ( {0} ) Options read: {1}", new Object[]{opts.getHost() + ":" + opts.getPort(), opts.toJson().encode()});
        this.client = new RedisClientStub(vertx, opts);
        this.extra = (RedisExtra)Ut.deserialize((JsonObject)options, RedisExtra.class);
        return this;
    }

    public long retryTimeout() {
        return this.extra.getRetryTimeout();
    }

    public Session createSession(long timeout) {
        return new RedisSession(random, timeout, 16);
    }

    public Session createSession(long timeout, int length) {
        return new RedisSession(random, timeout, length);
    }

    private RedisSession createSession() {
        return new RedisSession(random, this.extra.getTimeout(), 16);
    }

    public void clear(Handler<AsyncResult<Void>> handler) {
        HashSet<String> idSet = new HashSet<String>(this.sessionIds);
        idSet.forEach(sessionId -> this.client.del(sessionId, res -> {
            if (res.succeeded()) {
                this.sessionIds.remove(sessionId);
            }
        }));
        handler.handle((Object)Future.succeededFuture());
    }

    public void size(Handler<AsyncResult<Integer>> handler) {
        handler.handle((Object)Future.succeededFuture((Object)this.sessionIds.size()));
    }

    public void close() {
        this.client.close(handler -> {
            if (handler.succeeded()) {
                LOGGER.info("[ ZERO ] ( Redis ) The client has been closed successfully !", new Object[0]);
            }
        });
    }

    public void delete(String id, Handler<AsyncResult<Void>> handler) {
        LOGGER.debug("[ ZERO ] ( Redis ) Call {1} method: id = {0}", new Object[]{id, "delete(String)"});
        this.client.del(id, res -> {
            if (res.succeeded()) {
                this.sessionIds.remove(id);
                LOGGER.info("[ ZERO ] ( Redis ) The client has been removed: {0}", new Object[]{id});
                handler.handle((Object)Future.succeededFuture());
            } else {
                res.cause().printStackTrace();
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        });
    }

    public void get(String id, Handler<AsyncResult<Session>> handler) {
        LOGGER.debug("[ ZERO ] ( Redis ) Call {1} method: id = {0}", new Object[]{id, "get(String)"});
        this.client.getBinary(id, res -> {
            if (res.succeeded()) {
                Buffer buffer = (Buffer)res.result();
                if (Objects.nonNull(buffer)) {
                    RedisSession session = this.createSession();
                    if (0 < buffer.length()) {
                        session.readFromBuffer(0, buffer);
                    }
                    handler.handle((Object)Future.succeededFuture((Object)((Object)session)));
                } else {
                    handler.handle((Object)Future.succeededFuture((Object)this.localMap.get((Object)id)));
                }
            } else {
                res.cause().printStackTrace();
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        });
    }

    public void put(Session session, Handler<AsyncResult<Void>> handler) {
        String id = session.id();
        LOGGER.debug("[ ZERO ] ( Redis ) Call {1} method: id = {0}", new Object[]{id, "put(Session)"});
        this.client.getBinary(id, res -> {
            if (res.succeeded()) {
                RedisSession finalSession;
                Buffer buffer = (Buffer)res.result();
                RedisSession oldSession = this.createSession();
                if (Objects.isNull(buffer)) {
                    RedisSession sessionImpl;
                    finalSession = sessionImpl = (RedisSession)session;
                } else {
                    RedisSession newSession = (RedisSession)session;
                    oldSession.readFromBuffer(0, buffer);
                    if (oldSession.version() != newSession.version()) {
                        _409SessionVersionException error = new _409SessionVersionException(this.getClass(), oldSession.version(), newSession.version());
                        handler.handle((Object)Future.failedFuture((Throwable)((Object)error)));
                        return;
                    }
                    finalSession = newSession;
                }
                finalSession.incrementVersion();
                this.writeSession(session, (Handler<AsyncResult<String>>)((Handler)res2 -> {
                    if (res2.succeeded()) {
                        if (Objects.nonNull(res2.result())) {
                            String added = (String)res2.result();
                            if (!this.sessionIds.contains(added)) {
                                this.sessionIds.add((String)res2.result());
                            }
                            this.localMap.put((Object)added, (Object)session);
                        }
                        LOGGER.info("[ ZERO ] ( Redis ) Session New = {0} / Old = {1}", new Object[]{finalSession.id(), null == oldSession ? null : oldSession.id()});
                    } else {
                        res2.cause().printStackTrace();
                        handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                    }
                }));
            } else {
                res.cause().printStackTrace();
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        });
    }

    private void writeSession(Session session, Handler<AsyncResult<String>> handler) {
        Buffer buffer = Buffer.buffer();
        RedisSession sessionImpl = (RedisSession)session;
        sessionImpl.writeToBuffer(buffer);
        SetOptions options = new SetOptions().setPX(session.timeout());
        String key = sessionImpl.id();
        this.client.setBinaryWithOptions(key, buffer, options, res -> {
            if (res.succeeded()) {
                LOGGER.info("[ ZERO ] ( Redis ) Set key: {0}", new Object[]{Ut.fromJoin(session.data().keySet())});
                handler.handle((Object)Future.succeededFuture((Object)key));
            } else {
                res.cause().printStackTrace();
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        });
    }
}

