/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.redis;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.RedisTransaction;
import io.vertx.redis.Script;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import io.vertx.redis.impl.RedisEncoding;
import io.vertx.redis.op.AggregateOptions;
import io.vertx.redis.op.BitFieldOptions;
import io.vertx.redis.op.BitFieldOverflowOptions;
import io.vertx.redis.op.BitOperation;
import io.vertx.redis.op.ClientReplyOptions;
import io.vertx.redis.op.FailoverOptions;
import io.vertx.redis.op.GeoMember;
import io.vertx.redis.op.GeoRadiusOptions;
import io.vertx.redis.op.GeoUnit;
import io.vertx.redis.op.InsertOptions;
import io.vertx.redis.op.KillFilter;
import io.vertx.redis.op.LimitOptions;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.ObjectCmd;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.RangeOptions;
import io.vertx.redis.op.ResetOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.ScriptDebugOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SlotCmd;
import io.vertx.redis.op.SortOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

public class RedisClientStub
implements RedisClient {
    private final Vertx vertx;
    private final RedisOptions options;
    private final AtomicReference<CompletableFuture<Redis>> redis = new AtomicReference();

    public RedisClientStub(Vertx vertx, RedisOptions options) {
        this.vertx = vertx;
        this.options = options;
    }

    private static List<?> toPayload(Object ... parameters) {
        ArrayList<Object> result = new ArrayList<Object>(parameters.length);
        for (Object param : parameters) {
            if (param instanceof JsonArray) {
                param = ((JsonArray)param).getList();
            }
            if (param instanceof JsonObject) {
                param = ((JsonObject)param).getMap();
            }
            if (param instanceof Collection) {
                ((Collection)param).stream().filter(Objects::nonNull).forEach(result::add);
                continue;
            }
            if (param instanceof Map) {
                for (Map.Entry pair : ((Map)param).entrySet()) {
                    result.add(pair.getKey());
                    result.add(pair.getValue());
                }
                continue;
            }
            if (param instanceof Stream) {
                ((Stream)param).forEach(e -> {
                    if (e instanceof Object[]) {
                        Collections.addAll(result, (Object[])e);
                    } else {
                        result.add(e);
                    }
                });
                continue;
            }
            if (param == null) continue;
            result.add(param);
        }
        return result;
    }

    private static JsonArray toJsonArray(Response response) {
        JsonArray json = new JsonArray();
        if (response.type() != ResponseType.MULTI) {
            switch (response.type()) {
                case INTEGER: {
                    json.add(response.toLong());
                    break;
                }
                case SIMPLE: 
                case BULK: {
                    json.add(response.toString());
                }
            }
            return json;
        }
        for (Response r : response) {
            if (r == null) {
                json.addNull();
                continue;
            }
            switch (r.type()) {
                case INTEGER: {
                    json.add(r.toLong());
                    break;
                }
                case SIMPLE: 
                case BULK: {
                    json.add(r.toString());
                    break;
                }
                case MULTI: {
                    json.add(RedisClientStub.toJsonArray(r));
                }
            }
        }
        return json;
    }

    private static JsonObject toJsonObject(Response response) {
        JsonObject json = new JsonObject();
        for (String key : response.getKeys()) {
            Response value = response.get(key);
            switch (value.type()) {
                case INTEGER: {
                    json.put(key, value.toLong());
                    break;
                }
                case SIMPLE: 
                case BULK: {
                    json.put(key, value.toString());
                    break;
                }
                case MULTI: {
                    json.put(key, RedisClientStub.toJsonArray(value));
                }
            }
        }
        return json;
    }

    private void send(Command command, List arguments, Handler<AsyncResult<Response>> handler) {
        CompletableFuture<Object> fut;
        Request req = Request.cmd((Command)command);
        if (arguments != null) {
            for (Object o : arguments) {
                if (o == null) {
                    req.nullArg();
                    continue;
                }
                if (o instanceof Buffer) {
                    req.arg((Buffer)o);
                    continue;
                }
                req.arg(o.toString());
            }
        }
        if ((fut = this.redis.get()) == null) {
            CompletableFuture f = new CompletableFuture();
            if (this.redis.compareAndSet(null, f)) {
                fut = f;
                Redis.createClient((Vertx)this.vertx, (io.vertx.redis.client.RedisOptions)new io.vertx.redis.client.RedisOptions().setNetClientOptions((NetClientOptions)this.options).setEndpoint(this.options.isDomainSocket() ? SocketAddress.domainSocketAddress((String)this.options.getDomainSocketAddress()) : SocketAddress.inetSocketAddress((int)this.options.getPort(), (String)this.options.getHost())).setPassword(this.options.getAuth()).setSelect(this.options.getSelect())).connect(onReady -> {
                    if (onReady.succeeded()) {
                        f.complete(onReady.result());
                    } else {
                        f.completeExceptionally(onReady.cause());
                    }
                });
            } else {
                fut = this.redis.get();
            }
        }
        fut.whenComplete((client, err) -> {
            if (err == null) {
                client.send(req, handler);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)err));
            }
        });
    }

    private void sendLong(Command command, List arguments, Handler<AsyncResult<Long>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((Response)ar.result()).toLong()));
            }
        }));
    }

    private void sendString(Command command, List arguments, Handler<AsyncResult<String>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture(ar.result() != null ? ((Response)ar.result()).toString() : null));
            }
        }));
    }

    private void sendJsonArray(Command command, List arguments, Handler<AsyncResult<JsonArray>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture(ar.result() != null ? RedisClientStub.toJsonArray((Response)ar.result()) : null));
            }
        }));
    }

    private void sendVoid(Command command, List arguments, Handler<AsyncResult<Void>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture());
            }
        }));
    }

    private void sendBuffer(Command command, List arguments, Handler<AsyncResult<Buffer>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                Response response = (Response)ar.result();
                if (Objects.isNull(response)) {
                    handler.handle((Object)Future.succeededFuture(null));
                } else {
                    handler.handle((Object)Future.succeededFuture((Object)((Response)ar.result()).toBuffer()));
                }
            }
        }));
    }

    private void sendJsonObject(Command command, List arguments, Handler<AsyncResult<JsonObject>> handler) {
        this.send(command, arguments, (Handler<AsyncResult<Response>>)((Handler)ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)RedisClientStub.toJsonObject((Response)ar.result())));
            }
        }));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        CompletableFuture prev = this.redis.getAndSet(null);
        if (prev != null) {
            prev.whenComplete((client, err) -> {
                if (err == null) {
                    client.close();
                    if (handler != null) {
                        handler.handle((Object)Future.succeededFuture());
                    }
                } else if (handler != null) {
                    handler.handle((Object)Future.failedFuture((Throwable)err.getCause()));
                }
            });
        }
    }

    public RedisClient append(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.APPEND, RedisClientStub.toPayload(key, value), handler);
        return this;
    }

    public RedisClient auth(String password, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.AUTH, RedisClientStub.toPayload(password), handler);
        return this;
    }

    public RedisClient bgrewriteaof(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.BGREWRITEAOF, null, handler);
        return this;
    }

    public RedisClient bgsave(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.BGSAVE, null, handler);
        return this;
    }

    public RedisClient bitcount(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.BITCOUNT, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient bitcountRange(String key, long start, long end, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.BITCOUNT, RedisClientStub.toPayload(key, start, end), handler);
        return this;
    }

    public RedisClient bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.BITOP, RedisClientStub.toPayload(operation.name(), destkey, keys), handler);
        return this;
    }

    public RedisClient bitpos(String key, int bit, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.BITPOS, RedisClientStub.toPayload(key, bit), handler);
        return this;
    }

    public RedisClient bitposFrom(String key, int bit, int start, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.BITPOS, RedisClientStub.toPayload(key, bit, start), handler);
        return this;
    }

    public RedisClient bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.BITPOS, RedisClientStub.toPayload(key, bit, start, stop), handler);
        return this;
    }

    public RedisClient blpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.BLPOP, RedisClientStub.toPayload(key, seconds), handler);
        return this;
    }

    public RedisClient blpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.BLPOP, RedisClientStub.toPayload(keys, seconds), handler);
        return this;
    }

    public RedisClient brpop(String key, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.BRPOP, RedisClientStub.toPayload(key, seconds), handler);
        return this;
    }

    public RedisClient brpopMany(List<String> keys, int seconds, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.BRPOP, RedisClientStub.toPayload(keys, seconds), handler);
        return this;
    }

    public RedisClient brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.BRPOPLPUSH, RedisClientStub.toPayload(key, destkey, seconds), handler);
        return this;
    }

    public RedisClient clientKill(KillFilter filter, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.CLIENT, RedisClientStub.toPayload("kill", filter.toJsonArray().getList()), handler);
        return this;
    }

    public RedisClient clientList(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CLIENT, RedisClientStub.toPayload("list"), handler);
        return this;
    }

    public RedisClient clientGetname(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CLIENT, RedisClientStub.toPayload("GETNAME"), handler);
        return this;
    }

    public RedisClient clientPause(long millis, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CLIENT, RedisClientStub.toPayload("PAUSE", millis), handler);
        return this;
    }

    public RedisClient clientSetname(String name, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CLIENT, RedisClientStub.toPayload("SETNAME", name), handler);
        return this;
    }

    public RedisClient clusterAddslots(List<Long> slots, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientStub.toPayload("ADDSLOTS"), handler);
        return this;
    }

    public RedisClient clusterCountFailureReports(String nodeId, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.CLUSTER, RedisClientStub.toPayload("COUNT-FAILURE-REPORTS", nodeId), handler);
        return this;
    }

    public RedisClient clusterCountkeysinslot(long slot, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.CLUSTER, RedisClientStub.toPayload("COUNTKEYSINSLOT", slot), handler);
        return this;
    }

    public RedisClient clusterDelslots(long slot, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientStub.toPayload("DELSLOTS", slot), handler);
        return this;
    }

    public RedisClient clusterDelslotsMany(List<Long> slots, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientStub.toPayload("DELSLOTS", slots), handler);
        return this;
    }

    public RedisClient clusterFailover(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientStub.toPayload("FAILOVER"), handler);
        return this;
    }

    public RedisClient clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientStub.toPayload("FAILOVER", options), handler);
        return this;
    }

    public RedisClient clusterForget(String nodeId, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientStub.toPayload("FORGET", nodeId), handler);
        return this;
    }

    public RedisClient clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.CLUSTER, RedisClientStub.toPayload("GETKEYSINSLOT", slot, count), handler);
        return this;
    }

    public RedisClient clusterInfo(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.CLUSTER, RedisClientStub.toPayload("INFO"), handler);
        return this;
    }

    public RedisClient clusterKeyslot(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.CLUSTER, RedisClientStub.toPayload("KEYSLOT", key), handler);
        return this;
    }

    public RedisClient clusterMeet(String ip, long port, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientStub.toPayload("MEET", ip, port), handler);
        return this;
    }

    public RedisClient clusterNodes(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.CLUSTER, RedisClientStub.toPayload("NODES"), handler);
        return this;
    }

    public RedisClient clusterReplicate(String nodeId, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientStub.toPayload("REPLICATE", nodeId), handler);
        return this;
    }

    public RedisClient clusterReset(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientStub.toPayload("RESET"), handler);
        return this;
    }

    public RedisClient clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientStub.toPayload("RESET", options), handler);
        return this;
    }

    public RedisClient clusterSaveconfig(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientStub.toPayload("SAVECONFIG"), handler);
        return this;
    }

    public RedisClient clusterSetConfigEpoch(long epoch, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientStub.toPayload("SET-CONFIG-EPOCH", epoch), handler);
        return this;
    }

    public RedisClient clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientStub.toPayload("SETSLOT", slot, subcommand), handler);
        return this;
    }

    public RedisClient clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.CLUSTER, RedisClientStub.toPayload("SETSLOT", slot, subcommand, nodeId), handler);
        return this;
    }

    public RedisClient clusterSlaves(String nodeId, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.CLUSTER, RedisClientStub.toPayload("SLAVES", nodeId), handler);
        return this;
    }

    public RedisClient clusterSlots(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.CLUSTER, RedisClientStub.toPayload("SLOTS"), handler);
        return this;
    }

    public RedisClient command(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.COMMAND, null, handler);
        return this;
    }

    public RedisClient commandCount(Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.COMMAND, RedisClientStub.toPayload("COUNT"), handler);
        return this;
    }

    public RedisClient commandGetkeys(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.COMMAND, RedisClientStub.toPayload("GETKEYS"), handler);
        return this;
    }

    public RedisClient commandInfo(List<String> commands, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.COMMAND, RedisClientStub.toPayload("INFO", commands), handler);
        return this;
    }

    public RedisClient configGet(String parameter, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.CONFIG, RedisClientStub.toPayload("GET", parameter), handler);
        return this;
    }

    public RedisClient configRewrite(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CONFIG, RedisClientStub.toPayload("REWRITE"), handler);
        return this;
    }

    public RedisClient configSet(String parameter, String value, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CONFIG, RedisClientStub.toPayload("SET", parameter, value), handler);
        return this;
    }

    public RedisClient configResetstat(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CONFIG, RedisClientStub.toPayload("RESETSTAT"), handler);
        return this;
    }

    public RedisClient dbsize(Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.DBSIZE, null, handler);
        return this;
    }

    public RedisClient debugObject(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.DEBUG, RedisClientStub.toPayload("OBJECT", key), handler);
        return this;
    }

    public RedisClient debugSegfault(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.DEBUG, RedisClientStub.toPayload("SEGFAULT"), handler);
        return this;
    }

    public RedisClient decr(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.DECR, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient decrby(String key, long decrement, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.DECRBY, RedisClientStub.toPayload(key, decrement), handler);
        return this;
    }

    public RedisClient del(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.DEL, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient delMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.DEL, RedisClientStub.toPayload(keys), handler);
        return this;
    }

    public RedisClient dump(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.DUMP, RedisClientStub.toPayload(key), (Handler<AsyncResult<String>>)((Handler)dump -> {
            if (dump.failed()) {
                handler.handle(dump);
            } else {
                handler.handle((Object)Future.succeededFuture((Object)RedisEncoding.encode((String)((String)dump.result()))));
            }
        }));
        return this;
    }

    public RedisClient echo(String message, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.ECHO, RedisClientStub.toPayload(message), handler);
        return this;
    }

    public RedisClient eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        keys = keys != null ? keys : Collections.emptyList();
        args = args != null ? args : Collections.emptyList();
        this.sendJsonArray(Command.EVAL, RedisClientStub.toPayload(script, keys.size(), keys, args), handler);
        return this;
    }

    public RedisClient evalsha(String sha1, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        keys = keys != null ? keys : Collections.emptyList();
        args = args != null ? args : Collections.emptyList();
        this.sendJsonArray(Command.EVALSHA, RedisClientStub.toPayload(sha1, keys.size(), keys, args), handler);
        return this;
    }

    public RedisClient evalScript(Script script, List<String> keys, List<String> args, Handler<AsyncResult<JsonArray>> handler) {
        this.evalsha(script.getSha1(), keys, args, (Handler<AsyncResult<JsonArray>>)((Handler)res -> {
            if (res.failed() && res.cause().getMessage().startsWith("NOSCRIPT")) {
                this.eval(script.getScript(), keys, args, handler);
            } else {
                handler.handle(res);
            }
        }));
        return this;
    }

    public RedisClient exists(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.EXISTS, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient existsMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.EXISTS, RedisClientStub.toPayload(keys), handler);
        return this;
    }

    public RedisClient expire(String key, long seconds, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.EXPIRE, RedisClientStub.toPayload(key, seconds), handler);
        return this;
    }

    public RedisClient expireat(String key, long seconds, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.EXPIREAT, RedisClientStub.toPayload(key, seconds), handler);
        return this;
    }

    public RedisClient flushall(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.FLUSHALL, null, handler);
        return this;
    }

    public RedisClient flushdb(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.FLUSHDB, null, handler);
        return this;
    }

    public RedisClient get(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.GET, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient getBinary(String key, Handler<AsyncResult<Buffer>> handler) {
        this.sendBuffer(Command.GET, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient getbit(String key, long offset, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.GETBIT, RedisClientStub.toPayload(key, offset), handler);
        return this;
    }

    public RedisClient getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.GETRANGE, RedisClientStub.toPayload(key, start, end), handler);
        return this;
    }

    public RedisClient getset(String key, String value, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.GETSET, RedisClientStub.toPayload(key, value), handler);
        return this;
    }

    public RedisClient hdel(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HDEL, RedisClientStub.toPayload(key, field), handler);
        return this;
    }

    public RedisClient hdelMany(String key, List<String> fields, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HDEL, RedisClientStub.toPayload(key, fields), handler);
        return this;
    }

    public RedisClient hexists(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HEXISTS, RedisClientStub.toPayload(key, field), handler);
        return this;
    }

    public RedisClient hget(String key, String field, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.HGET, RedisClientStub.toPayload(key, field), handler);
        return this;
    }

    public RedisClient hgetall(String key, Handler<AsyncResult<JsonObject>> handler) {
        this.sendJsonObject(Command.HGETALL, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient hincrby(String key, String field, long increment, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HINCRBY, RedisClientStub.toPayload(key, field, increment), handler);
        return this;
    }

    public RedisClient hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.HINCRBYFLOAT, RedisClientStub.toPayload(key, field, increment), handler);
        return this;
    }

    public RedisClient hkeys(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.HKEYS, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient hlen(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HLEN, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient hmget(String key, List<String> fields, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.HMGET, RedisClientStub.toPayload(key, fields), handler);
        return this;
    }

    public RedisClient hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.HMSET, RedisClientStub.toPayload(key, values), handler);
        return this;
    }

    public RedisClient hset(String key, String field, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HSET, RedisClientStub.toPayload(key, field, value), handler);
        return this;
    }

    public RedisClient hsetnx(String key, String field, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HSETNX, RedisClientStub.toPayload(key, field, value), handler);
        return this;
    }

    public RedisClient hvals(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.HVALS, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient incr(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.INCR, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient incrby(String key, long increment, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.INCRBY, RedisClientStub.toPayload(key, increment), handler);
        return this;
    }

    public RedisClient incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.INCRBYFLOAT, RedisClientStub.toPayload(key, increment), handler);
        return this;
    }

    public RedisClient info(Handler<AsyncResult<JsonObject>> handler) {
        this.sendString(Command.INFO, Collections.emptyList(), (Handler<AsyncResult<String>>)((Handler)info -> {
            if (info.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)info.cause()));
            } else {
                JsonObject result;
                JsonObject section = result = new JsonObject();
                for (String line : ((String)info.result()).split("\r?\n")) {
                    if (line.length() <= 0) continue;
                    if (line.charAt(0) == '#') {
                        section = new JsonObject();
                        result.put(line.substring(2).toLowerCase(), section);
                        continue;
                    }
                    int sep = line.indexOf(58);
                    section.put(line.substring(0, sep), line.substring(sep + 1));
                }
                handler.handle((Object)Future.succeededFuture((Object)result));
            }
        }));
        return this;
    }

    public RedisClient infoSection(String section, Handler<AsyncResult<JsonObject>> handler) {
        this.sendString(Command.INFO, RedisClientStub.toPayload(section), (Handler<AsyncResult<String>>)((Handler)info -> {
            if (info.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)info.cause()));
            } else {
                JsonObject result;
                JsonObject sectionJson = result = new JsonObject();
                for (String line : ((String)info.result()).split("\r?\n")) {
                    if (line.length() <= 0) continue;
                    if (line.charAt(0) == '#') {
                        sectionJson = new JsonObject();
                        result.put(line.substring(2).toLowerCase(), sectionJson);
                        continue;
                    }
                    int sep = line.indexOf(58);
                    sectionJson.put(line.substring(0, sep), line.substring(sep + 1));
                }
                handler.handle((Object)Future.succeededFuture((Object)result));
            }
        }));
        return this;
    }

    public RedisClient keys(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.KEYS, RedisClientStub.toPayload(pattern), handler);
        return this;
    }

    public RedisClient lastsave(Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.LASTSAVE, null, handler);
        return this;
    }

    public RedisClient lindex(String key, int index, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.LINDEX, RedisClientStub.toPayload(key, index), handler);
        return this;
    }

    public RedisClient linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.LINSERT, RedisClientStub.toPayload(key, option.name(), pivot, value), handler);
        return this;
    }

    public RedisClient llen(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.LLEN, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient lpop(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.LPOP, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient lpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.LPUSH, RedisClientStub.toPayload(key, values), handler);
        return this;
    }

    public RedisClient lpush(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.LPUSH, RedisClientStub.toPayload(key, value), handler);
        return this;
    }

    public RedisClient lpushx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.LPUSHX, RedisClientStub.toPayload(key, value), handler);
        return this;
    }

    public RedisClient lrange(String key, long from, long to, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.LRANGE, RedisClientStub.toPayload(key, from, to), handler);
        return this;
    }

    public RedisClient lrem(String key, long count, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.LREM, RedisClientStub.toPayload(key, count, value), handler);
        return this;
    }

    public RedisClient lset(String key, long index, String value, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.LSET, RedisClientStub.toPayload(key, index, value), handler);
        return this;
    }

    public RedisClient ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.LTRIM, RedisClientStub.toPayload(key, from, to), handler);
        return this;
    }

    public RedisClient mget(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.MGET, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient mgetMany(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.MGET, RedisClientStub.toPayload(keys), handler);
        return this;
    }

    public RedisClient migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.MIGRATE, RedisClientStub.toPayload(host, port, key, destdb, timeout, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient monitor(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.MONITOR, null, handler);
        return this;
    }

    public RedisClient move(String key, int destdb, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.MOVE, RedisClientStub.toPayload(key, destdb), handler);
        return this;
    }

    public RedisClient mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.MSET, RedisClientStub.toPayload(keyvals), handler);
        return this;
    }

    public RedisClient msetnx(JsonObject keyvals, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.MSETNX, RedisClientStub.toPayload(keyvals), handler);
        return this;
    }

    public RedisClient object(String key, ObjectCmd cmd, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.OBJECT, RedisClientStub.toPayload(cmd.name(), key), handler);
        return this;
    }

    public RedisClient persist(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PERSIST, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient pexpire(String key, long millis, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PEXPIRE, RedisClientStub.toPayload(key, millis), handler);
        return this;
    }

    public RedisClient pexpireat(String key, long millis, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PEXPIREAT, RedisClientStub.toPayload(key, millis), handler);
        return this;
    }

    public RedisClient pfadd(String key, String element, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PFADD, RedisClientStub.toPayload(key, element), handler);
        return this;
    }

    public RedisClient pfaddMany(String key, List<String> elements, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PFADD, RedisClientStub.toPayload(key, elements), handler);
        return this;
    }

    public RedisClient pfcount(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PFCOUNT, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient pfcountMany(List<String> key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PFCOUNT, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.PFMERGE, RedisClientStub.toPayload(destkey, keys), handler);
        return this;
    }

    public RedisClient ping(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.PING, null, handler);
        return this;
    }

    public RedisClient psetex(String key, long millis, String value, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.PSETEX, RedisClientStub.toPayload(key, millis, value), handler);
        return this;
    }

    public RedisClient psubscribe(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.PSUBSCRIBE, RedisClientStub.toPayload(pattern), handler);
        return this;
    }

    public RedisClient psubscribeMany(List<String> patterns, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.PSUBSCRIBE, RedisClientStub.toPayload(patterns), handler);
        return this;
    }

    public RedisClient pubsubChannels(String pattern, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.PUBSUB, RedisClientStub.toPayload("CHANNELS", pattern == null || "".equals(pattern) ? null : pattern), handler);
        return this;
    }

    public RedisClient pubsubNumsub(List<String> channels, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.PUBSUB, RedisClientStub.toPayload("NUMSUB", channels), handler);
        return this;
    }

    public RedisClient pubsubNumpat(Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PUBSUB, RedisClientStub.toPayload("NUMPAT"), handler);
        return this;
    }

    public RedisClient pttl(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PTTL, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient publish(String channel, String message, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.PUBLISH, RedisClientStub.toPayload(channel, message), handler);
        return this;
    }

    public RedisClient punsubscribe(List<String> patterns, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.PUNSUBSCRIBE, RedisClientStub.toPayload(patterns), handler);
        return this;
    }

    public RedisClient randomkey(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.RANDOMKEY, null, handler);
        return this;
    }

    public RedisClient rename(String key, String newkey, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.RENAME, RedisClientStub.toPayload(key, newkey), handler);
        return this;
    }

    public RedisClient renamenx(String key, String newkey, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.RENAMENX, RedisClientStub.toPayload(key, newkey), handler);
        return this;
    }

    public RedisClient restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.RESTORE, RedisClientStub.toPayload(key, millis, RedisEncoding.decode((String)serialized)), handler);
        return this;
    }

    public RedisClient role(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ROLE, null, handler);
        return this;
    }

    public RedisClient rpop(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.RPOP, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.RPOPLPUSH, RedisClientStub.toPayload(key, destkey), handler);
        return this;
    }

    public RedisClient rpushMany(String key, List<String> values, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.RPUSH, RedisClientStub.toPayload(key, values), handler);
        return this;
    }

    public RedisClient rpush(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.RPUSH, RedisClientStub.toPayload(key, value), handler);
        return this;
    }

    public RedisClient rpushx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.RPUSHX, RedisClientStub.toPayload(key, value), handler);
        return this;
    }

    public RedisClient sadd(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SADD, RedisClientStub.toPayload(key, member), handler);
        return this;
    }

    public RedisClient saddMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SADD, RedisClientStub.toPayload(key, members), handler);
        return this;
    }

    public RedisClient save(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SAVE, null, handler);
        return this;
    }

    public RedisClient scard(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SCARD, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient scriptExists(String script, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SCRIPT, RedisClientStub.toPayload("EXISTS", script), handler);
        return this;
    }

    public RedisClient scriptExistsMany(List<String> scripts, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SCRIPT, RedisClientStub.toPayload("EXISTS", scripts), handler);
        return this;
    }

    public RedisClient scriptFlush(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SCRIPT, RedisClientStub.toPayload("FLUSH"), handler);
        return this;
    }

    public RedisClient scriptKill(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SCRIPT, RedisClientStub.toPayload("KILL"), handler);
        return this;
    }

    public RedisClient scriptLoad(String script, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SCRIPT, RedisClientStub.toPayload("LOAD", script), handler);
        return this;
    }

    public RedisClient sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SDIFF, RedisClientStub.toPayload(key, cmpkeys), handler);
        return this;
    }

    public RedisClient sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SDIFFSTORE, RedisClientStub.toPayload(destkey, key, cmpkeys), handler);
        return this;
    }

    public RedisClient select(int dbindex, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SELECT, RedisClientStub.toPayload(dbindex), handler);
        return this;
    }

    public RedisClient set(String key, String value, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.SET, RedisClientStub.toPayload(key, value), handler);
        return this;
    }

    public RedisClient setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SET, RedisClientStub.toPayload(key, value, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient setBinary(String key, Buffer value, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.SET, RedisClientStub.toPayload(key, value), handler);
        return this;
    }

    public RedisClient setBinaryWithOptions(String key, Buffer value, SetOptions options, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.SET, RedisClientStub.toPayload(key, value, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient setbit(String key, long offset, int bit, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SETBIT, RedisClientStub.toPayload(key, offset, bit), handler);
        return this;
    }

    public RedisClient setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SETEX, RedisClientStub.toPayload(key, seconds, value), handler);
        return this;
    }

    public RedisClient setnx(String key, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SETNX, RedisClientStub.toPayload(key, value), handler);
        return this;
    }

    public RedisClient setrange(String key, int offset, String value, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SETRANGE, RedisClientStub.toPayload(key, offset, value), handler);
        return this;
    }

    public RedisClient sinter(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SINTER, RedisClientStub.toPayload(keys), handler);
        return this;
    }

    public RedisClient sinterstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SINTERSTORE, RedisClientStub.toPayload(destkey, keys), handler);
        return this;
    }

    public RedisClient sismember(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SISMEMBER, RedisClientStub.toPayload(key, member), handler);
        return this;
    }

    public RedisClient slaveof(String host, int port, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SLAVEOF, RedisClientStub.toPayload(host, port), handler);
        return this;
    }

    public RedisClient slaveofNoone(Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SLAVEOF, RedisClientStub.toPayload("NO", "ONE"), handler);
        return this;
    }

    public RedisClient slowlogGet(int limit, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SLOWLOG, RedisClientStub.toPayload("GET", limit < 0 ? null : Integer.valueOf(limit)), handler);
        return this;
    }

    public RedisClient slowlogLen(Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SLOWLOG, RedisClientStub.toPayload("LEN"), handler);
        return this;
    }

    public RedisClient slowlogReset(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.SLOWLOG, RedisClientStub.toPayload("RESET"), handler);
        return this;
    }

    public RedisClient smembers(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SMEMBERS, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient smove(String key, String destkey, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SMOVE, RedisClientStub.toPayload(key, destkey, member), handler);
        return this;
    }

    public RedisClient sort(String key, SortOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SORT, RedisClientStub.toPayload(key, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient spop(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SPOP, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient spopMany(String key, int count, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SPOP, RedisClientStub.toPayload(key, count), handler);
        return this;
    }

    public RedisClient srandmember(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SRANDMEMBER, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient srandmemberCount(String key, int count, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SRANDMEMBER, RedisClientStub.toPayload(key, count), handler);
        return this;
    }

    public RedisClient srem(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SREM, RedisClientStub.toPayload(key, member), handler);
        return this;
    }

    public RedisClient sremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SREM, RedisClientStub.toPayload(key, members), handler);
        return this;
    }

    public RedisClient strlen(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.STRLEN, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient subscribe(String channel, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SUBSCRIBE, RedisClientStub.toPayload(channel), handler);
        return this;
    }

    public RedisClient subscribeMany(List<String> channels, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SUBSCRIBE, RedisClientStub.toPayload(channels), handler);
        return this;
    }

    public RedisClient sunion(List<String> keys, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SUNION, RedisClientStub.toPayload(keys), handler);
        return this;
    }

    public RedisClient sunionstore(String destkey, List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.SUNIONSTORE, RedisClientStub.toPayload(destkey, keys), handler);
        return this;
    }

    public RedisClient sync(Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.SYNC, null, handler);
        return this;
    }

    public RedisClient time(Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.TIME, null, handler);
        return this;
    }

    public RedisTransaction transaction() {
        return new RedisTransactionImpl();
    }

    public RedisClient ttl(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.TTL, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient type(String key, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.TYPE, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient unsubscribe(List<String> channels, Handler<AsyncResult<Void>> handler) {
        this.sendVoid(Command.UNSUBSCRIBE, RedisClientStub.toPayload(channels), handler);
        return this;
    }

    public RedisClient wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.WAIT, RedisClientStub.toPayload(numSlaves, timeout), handler);
        return this;
    }

    public RedisClient zadd(String key, double score, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZADD, RedisClientStub.toPayload(key, score, member), handler);
        return this;
    }

    /*
     * Exception decompiling
     */
    public RedisClient zaddMany(String key, Map<String, Double> members, Handler<AsyncResult<Long>> handler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RedisClient zcard(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZCARD, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient zcount(String key, double min, double max, Handler<AsyncResult<Long>> handler) {
        String minVal = min == Double.NEGATIVE_INFINITY ? "-inf" : String.valueOf(min);
        String maxVal = max == Double.POSITIVE_INFINITY ? "+inf" : String.valueOf(max);
        this.sendLong(Command.ZCOUNT, RedisClientStub.toPayload(key, minVal, maxVal), handler);
        return this;
    }

    public RedisClient zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.ZINCRBY, RedisClientStub.toPayload(key, increment, member), handler);
        return this;
    }

    public RedisClient zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZINTERSTORE, RedisClientStub.toPayload(destkey, sets.size(), sets, options != null ? options.name() : null), handler);
        return this;
    }

    public RedisClient zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZINTERSTORE, RedisClientStub.toPayload(destkey, sets.size(), sets.keySet(), "WEIGHTS", sets.values(), options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient zlexcount(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZLEXCOUNT, RedisClientStub.toPayload(key, min, max), handler);
        return this;
    }

    public RedisClient zrange(String key, long start, long stop, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZRANGE, RedisClientStub.toPayload(key, start, stop), handler);
        return this;
    }

    public RedisClient zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZRANGE, RedisClientStub.toPayload(key, start, stop, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZRANGEBYLEX, RedisClientStub.toPayload(key, min, max, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZRANGEBYSCORE, RedisClientStub.toPayload(key, min, max, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient zrank(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZRANK, RedisClientStub.toPayload(key, member), handler);
        return this;
    }

    public RedisClient zrem(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZREM, RedisClientStub.toPayload(key, member), handler);
        return this;
    }

    public RedisClient zremMany(String key, List<String> members, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZREM, RedisClientStub.toPayload(key, members), handler);
        return this;
    }

    public RedisClient zremrangebylex(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZREMRANGEBYLEX, RedisClientStub.toPayload(key, min, max), handler);
        return this;
    }

    public RedisClient zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZREMRANGEBYRANK, RedisClientStub.toPayload(key, start, stop), handler);
        return this;
    }

    public RedisClient zremrangebyscore(String key, String min, String max, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZREMRANGEBYSCORE, RedisClientStub.toPayload(key, min, max), handler);
        return this;
    }

    public RedisClient zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZREVRANGE, RedisClientStub.toPayload(key, start, stop, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZREVRANGEBYLEX, RedisClientStub.toPayload(key, max, min, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZREVRANGEBYSCORE, RedisClientStub.toPayload(key, max, min, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient zrevrank(String key, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZREVRANK, RedisClientStub.toPayload(key, member), handler);
        return this;
    }

    public RedisClient zscore(String key, String member, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.ZSCORE, RedisClientStub.toPayload(key, member), handler);
        return this;
    }

    public RedisClient zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZUNIONSTORE, RedisClientStub.toPayload(destkey, sets.size(), sets, options != null ? options.name() : null), handler);
        return this;
    }

    public RedisClient zunionstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.ZUNIONSTORE, RedisClientStub.toPayload(destkey, sets.size(), sets.keySet(), "WEIGHTS", sets.values(), options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient scan(String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SCAN, RedisClientStub.toPayload(cursor, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.SSCAN, RedisClientStub.toPayload(key, cursor, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.HSCAN, RedisClientStub.toPayload(key, cursor, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.ZSCAN, RedisClientStub.toPayload(key, cursor, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.GEOADD, RedisClientStub.toPayload(key, longitude, latitude, member), handler);
        return this;
    }

    public RedisClient geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.GEOADD, RedisClientStub.toPayload(key, members), handler);
        return this;
    }

    public RedisClient geohash(String key, String member, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEOHASH, RedisClientStub.toPayload(key, member), handler);
        return this;
    }

    public RedisClient geohashMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEOHASH, RedisClientStub.toPayload(key, members), handler);
        return this;
    }

    public RedisClient geopos(String key, String member, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEOPOS, RedisClientStub.toPayload(key, member), handler);
        return this;
    }

    public RedisClient geoposMany(String key, List<String> members, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEOPOS, RedisClientStub.toPayload(key, members), handler);
        return this;
    }

    public RedisClient geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.GEODIST, RedisClientStub.toPayload(key, member1, member2), handler);
        return this;
    }

    public RedisClient geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.GEODIST, RedisClientStub.toPayload(key, member1, member2, unit), handler);
        return this;
    }

    public RedisClient georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEORADIUS, RedisClientStub.toPayload(key, longitude, latitude, radius, unit), handler);
        return this;
    }

    public RedisClient georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEORADIUS, RedisClientStub.toPayload(key, longitude, latitude, radius, unit, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEORADIUSBYMEMBER, RedisClientStub.toPayload(key, member, radius, unit), handler);
        return this;
    }

    public RedisClient georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.GEORADIUSBYMEMBER, RedisClientStub.toPayload(key, member, radius, unit, options != null ? options.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient clientReply(ClientReplyOptions options, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.CLIENT, RedisClientStub.toPayload("REPLY", options), handler);
        return this;
    }

    public RedisClient hstrlen(String key, String field, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.HSTRLEN, RedisClientStub.toPayload(key, field), handler);
        return this;
    }

    public RedisClient touch(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.TOUCH, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient touchMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.TOUCH, keys, handler);
        return this;
    }

    public RedisClient scriptDebug(ScriptDebugOptions scriptDebugOptions, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SCRIPT, RedisClientStub.toPayload("DEBUG", scriptDebugOptions), handler);
        return this;
    }

    public RedisClient bitfield(String key, BitFieldOptions bitFieldOptions, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.BITFIELD, RedisClientStub.toPayload(key, bitFieldOptions != null ? bitFieldOptions.toJsonArray() : null), handler);
        return this;
    }

    public RedisClient bitfieldWithOverflow(String key, BitFieldOptions bitFieldOptions, BitFieldOverflowOptions overflow, Handler<AsyncResult<JsonArray>> handler) {
        this.sendJsonArray(Command.BITFIELD, RedisClientStub.toPayload(key, bitFieldOptions != null ? bitFieldOptions.toJsonArray() : null, overflow), handler);
        return this;
    }

    public RedisClient unlink(String key, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.UNLINK, RedisClientStub.toPayload(key), handler);
        return this;
    }

    public RedisClient unlinkMany(List<String> keys, Handler<AsyncResult<Long>> handler) {
        this.sendLong(Command.UNLINK, RedisClientStub.toPayload(keys), handler);
        return this;
    }

    public RedisClient swapdb(int index1, int index2, Handler<AsyncResult<String>> handler) {
        this.sendString(Command.SWAPDB, RedisClientStub.toPayload(index1, index2), handler);
        return this;
    }

    public class RedisTransactionImpl
    implements RedisTransaction {
        public void close(Handler<AsyncResult<Void>> handler) {
            RedisClientStub.this.close(handler);
        }

        public RedisTransaction append(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.APPEND, RedisClientStub.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction auth(String password, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.AUTH, RedisClientStub.toPayload(new Object[]{password}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction bgrewriteaof(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.BGREWRITEAOF, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction bgsave(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.BGSAVE, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction bitcount(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.BITCOUNT, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction bitcountRange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.BITCOUNT, RedisClientStub.toPayload(new Object[]{key, start, end}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.BITOP, RedisClientStub.toPayload(new Object[]{operation.name(), destkey, keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction bitpos(String key, int bit, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.BITPOS, RedisClientStub.toPayload(new Object[]{key, bit}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction bitposFrom(String key, int bit, int start, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.BITPOS, RedisClientStub.toPayload(new Object[]{key, bit, start}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.BITPOS, RedisClientStub.toPayload(new Object[]{key, bit, start, stop}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction blpop(String key, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.BLPOP, RedisClientStub.toPayload(new Object[]{key, seconds}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction blpopMany(List<String> keys, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.BLPOP, RedisClientStub.toPayload(new Object[]{keys, seconds}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction brpop(String key, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.BRPOP, RedisClientStub.toPayload(new Object[]{key, seconds}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction brpopMany(List<String> keys, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.BRPOP, RedisClientStub.toPayload(new Object[]{keys, seconds}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.BRPOPLPUSH, RedisClientStub.toPayload(new Object[]{key, destkey, seconds}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clientKill(KillFilter filter, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLIENT, RedisClientStub.toPayload(new Object[]{"KILL", filter.toJsonArray().getList()}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clientList(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLIENT, RedisClientStub.toPayload(new Object[]{"LIST"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clientGetname(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLIENT, RedisClientStub.toPayload(new Object[]{"GETNAME"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clientPause(long millis, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLIENT, RedisClientStub.toPayload(new Object[]{"PAUSE", millis}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clientSetname(String name, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLIENT, RedisClientStub.toPayload(new Object[]{"SETNAME", name}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterAddslots(List<String> slots, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"ADDSLOTS"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterCountFailureReports(String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"COUNT-FAILURE-REPORTS", nodeId}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterCountkeysinslot(long slot, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"COUNTKEYSINSLOT", slot}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterDelslots(long slot, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"DELSLOTS", slot}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterDelslotsMany(List<String> slots, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"DELSLOTS", slots}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterFailover(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"FAILOVER"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"FAILOVER", options}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterForget(String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"FORGET", nodeId}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"GETKEYSINSLOT", slot, count}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterInfo(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"INFO"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterKeyslot(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"KEYSLOT", key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterMeet(String ip, long port, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"MEET", ip, port}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterNodes(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"NODES"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterReplicate(String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"REPLICATE", nodeId}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterReset(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"RESET"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"RESET", options}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterSaveconfig(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"SAVECONFIG"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterSetConfigEpoch(long epoch, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"SET-CONFIG-EPOCH", epoch}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"SETSLOT", slot, subcommand}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"SETSLOT", slot, subcommand, nodeId}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterSlaves(String nodeId, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"SLAVES", nodeId}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction clusterSlots(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CLUSTER, RedisClientStub.toPayload(new Object[]{"SLOTS"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction command(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.COMMAND, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction commandCount(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.COMMAND, RedisClientStub.toPayload(new Object[]{"COUNT"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction commandGetkeys(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.COMMAND, RedisClientStub.toPayload(new Object[]{"GETKEYS"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction commandInfo(List<String> commands, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.COMMAND, RedisClientStub.toPayload(new Object[]{"INFO", commands}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction configGet(String parameter, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CONFIG, RedisClientStub.toPayload(new Object[]{"GET", parameter}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction configRewrite(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CONFIG, RedisClientStub.toPayload(new Object[]{"REWRITE"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction configSet(String parameter, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CONFIG, RedisClientStub.toPayload(new Object[]{"SET", parameter, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction configResetstat(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.CONFIG, RedisClientStub.toPayload(new Object[]{"RESETSTAT"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction dbsize(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.DBSIZE, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction debugObject(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.DEBUG, RedisClientStub.toPayload(new Object[]{"OBJECT", key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction debugSegfault(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.DEBUG, RedisClientStub.toPayload(new Object[]{"SEGFAULT"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction decr(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.DECR, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction decrby(String key, long decrement, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.DECRBY, RedisClientStub.toPayload(new Object[]{key, decrement}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction del(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.DEL, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction delMany(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.DEL, RedisClientStub.toPayload(new Object[]{keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction discard(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.DISCARD, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction dump(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.DUMP, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)dump -> {
                if (dump.failed()) {
                    handler.handle(dump);
                } else {
                    handler.handle((Object)Future.succeededFuture((Object)RedisEncoding.encode((String)((String)dump.result()))));
                }
            });
            return this;
        }

        public RedisTransaction echo(String message, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ECHO, RedisClientStub.toPayload(new Object[]{message}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<String>> handler) {
            keys = keys != null ? keys : Collections.emptyList();
            args = args != null ? args : Collections.emptyList();
            RedisClientStub.this.sendString(Command.EVAL, RedisClientStub.toPayload(new Object[]{script, keys.size(), keys, args}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction evalsha(String sha1, List<String> keys, List<String> args, Handler<AsyncResult<String>> handler) {
            keys = keys != null ? keys : Collections.emptyList();
            args = args != null ? args : Collections.emptyList();
            RedisClientStub.this.sendString(Command.EVALSHA, RedisClientStub.toPayload(new Object[]{sha1, keys.size(), keys, args}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction exec(Handler<AsyncResult<JsonArray>> handler) {
            RedisClientStub.this.sendJsonArray(Command.EXEC, null, (Handler<AsyncResult<JsonArray>>)handler);
            return this;
        }

        public RedisTransaction exists(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.EXISTS, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction existsMany(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.EXISTS, RedisClientStub.toPayload(new Object[]{keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction expire(String key, int seconds, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.EXPIRE, RedisClientStub.toPayload(new Object[]{key, seconds}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction expireat(String key, long seconds, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.EXPIREAT, RedisClientStub.toPayload(new Object[]{key, seconds}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction flushall(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.FLUSHALL, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction flushdb(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.FLUSHDB, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction get(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GET, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction getBinary(String key, Handler<AsyncResult<Buffer>> handler) {
            RedisClientStub.this.sendBuffer(Command.GET, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<Buffer>>)handler);
            return this;
        }

        public RedisTransaction getbit(String key, long offset, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GETBIT, RedisClientStub.toPayload(new Object[]{key, offset}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GETRANGE, RedisClientStub.toPayload(new Object[]{key, start, end}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction getset(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GETSET, RedisClientStub.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hdel(String key, String field, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HDEL, RedisClientStub.toPayload(new Object[]{key, field}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hdelMany(String key, List<String> fields, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HDEL, RedisClientStub.toPayload(new Object[]{key, fields}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hexists(String key, String field, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HEXISTS, RedisClientStub.toPayload(new Object[]{key, field}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hget(String key, String field, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HGET, RedisClientStub.toPayload(new Object[]{key, field}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hgetall(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HGETALL, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hincrby(String key, String field, long increment, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HINCRBY, RedisClientStub.toPayload(new Object[]{key, field, increment}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HINCRBYFLOAT, RedisClientStub.toPayload(new Object[]{key, field, increment}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hkeys(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HKEYS, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hlen(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HLEN, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hmget(String key, List<String> fields, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HMGET, RedisClientStub.toPayload(new Object[]{key, fields}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HMSET, RedisClientStub.toPayload(new Object[]{key, values}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hset(String key, String field, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HSET, RedisClientStub.toPayload(new Object[]{key, field, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hsetnx(String key, String field, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HSETNX, RedisClientStub.toPayload(new Object[]{key, field, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hvals(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HVALS, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction incr(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.INCR, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction incrby(String key, long increment, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.INCRBY, RedisClientStub.toPayload(new Object[]{key, increment}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.INCRBYFLOAT, RedisClientStub.toPayload(new Object[]{key, increment}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction info(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.INFO, Collections.emptyList(), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction infoSection(String section, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.INFO, RedisClientStub.toPayload(new Object[]{section}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction keys(String pattern, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.KEYS, RedisClientStub.toPayload(new Object[]{pattern}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction lastsave(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.LASTSAVE, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction lindex(String key, int index, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.LINDEX, RedisClientStub.toPayload(new Object[]{key, index}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.LINSERT, RedisClientStub.toPayload(new Object[]{key, option.name(), pivot, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction llen(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.LLEN, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction lpop(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.LPOP, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction lpushMany(String key, List<String> values, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.LPUSH, RedisClientStub.toPayload(new Object[]{key, values}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction lpush(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.LPUSH, RedisClientStub.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction lpushx(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.LPUSHX, RedisClientStub.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction lrange(String key, long from, long to, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.LRANGE, RedisClientStub.toPayload(new Object[]{key, from, to}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction lrem(String key, long count, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.LREM, RedisClientStub.toPayload(new Object[]{key, count, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction lset(String key, long index, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.LSET, RedisClientStub.toPayload(new Object[]{key, index, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.LTRIM, RedisClientStub.toPayload(new Object[]{key, from, to}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction mget(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.MGET, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction mgetMany(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.MGET, RedisClientStub.toPayload(new Object[]{keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.MIGRATE, RedisClientStub.toPayload(new Object[]{host, port, key, destdb, timeout, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction monitor(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.MONITOR, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction move(String key, int destdb, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.MOVE, RedisClientStub.toPayload(new Object[]{key, destdb}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.MSET, RedisClientStub.toPayload(new Object[]{keyvals}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction msetnx(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.MSETNX, RedisClientStub.toPayload(new Object[]{keyvals}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction multi(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.MULTI, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction object(String key, ObjectCmd cmd, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.OBJECT, RedisClientStub.toPayload(new Object[]{cmd.name(), key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction persist(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PERSIST, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction pexpire(String key, long millis, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PEXPIRE, RedisClientStub.toPayload(new Object[]{key, millis}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction pexpireat(String key, long millis, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PEXPIREAT, RedisClientStub.toPayload(new Object[]{key, millis}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction pfadd(String key, String element, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PFADD, RedisClientStub.toPayload(new Object[]{key, element}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction pfaddMany(String key, List<String> elements, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PFADD, RedisClientStub.toPayload(new Object[]{key, elements}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction pfcount(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PFCOUNT, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction pfcountMany(List<String> key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PFCOUNT, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PFMERGE, RedisClientStub.toPayload(new Object[]{destkey, keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction ping(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PING, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction psetex(String key, long millis, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PSETEX, RedisClientStub.toPayload(new Object[]{key, millis, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction psubscribe(String pattern, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PSUBSCRIBE, RedisClientStub.toPayload(new Object[]{pattern}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction psubscribeMany(List<String> patterns, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PSUBSCRIBE, RedisClientStub.toPayload(new Object[]{patterns}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction pubsubChannels(String pattern, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PUBSUB, RedisClientStub.toPayload(new Object[]{"CHANNELS", pattern == null || "".equals(pattern) ? null : pattern}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction pubsubNumsub(List<String> channels, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PUBSUB, RedisClientStub.toPayload(new Object[]{"NUMSUB", channels}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction pubsubNumpat(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PUBSUB, RedisClientStub.toPayload(new Object[]{"NUMPAT"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction pttl(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PTTL, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction publish(String channel, String message, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PUBLISH, RedisClientStub.toPayload(new Object[]{channel, message}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction punsubscribe(List<String> patterns, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.PUNSUBSCRIBE, RedisClientStub.toPayload(new Object[]{patterns}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction randomkey(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.RANDOMKEY, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction rename(String key, String newkey, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.RENAME, RedisClientStub.toPayload(new Object[]{key, newkey}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction renamenx(String key, String newkey, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.RENAMENX, RedisClientStub.toPayload(new Object[]{key, newkey}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.RESTORE, RedisClientStub.toPayload(new Object[]{key, millis, RedisEncoding.decode((String)serialized)}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction role(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ROLE, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction rpop(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.RPOP, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.RPOPLPUSH, RedisClientStub.toPayload(new Object[]{key, destkey}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction rpushMany(String key, List<String> values, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.RPUSH, RedisClientStub.toPayload(new Object[]{key, values}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction rpush(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.RPUSH, RedisClientStub.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction rpushx(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.RPUSHX, RedisClientStub.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction sadd(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SADD, RedisClientStub.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction saddMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SADD, RedisClientStub.toPayload(new Object[]{key, members}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction save(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SAVE, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction scard(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SCARD, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction scriptExists(String script, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SCRIPT, RedisClientStub.toPayload(new Object[]{"EXISTS", script}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction scriptExistsMany(List<String> scripts, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SCRIPT, RedisClientStub.toPayload(new Object[]{"EXISTS", scripts}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction scriptFlush(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SCRIPT, RedisClientStub.toPayload(new Object[]{"FLUSH"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction scriptKill(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SCRIPT, RedisClientStub.toPayload(new Object[]{"KILL"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction scriptLoad(String script, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SCRIPT, RedisClientStub.toPayload(new Object[]{"LOAD", script}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SDIFF, RedisClientStub.toPayload(new Object[]{key, cmpkeys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SDIFFSTORE, RedisClientStub.toPayload(new Object[]{destkey, key, cmpkeys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction select(int dbindex, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SELECT, RedisClientStub.toPayload(new Object[]{dbindex}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction set(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SET, RedisClientStub.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SET, RedisClientStub.toPayload(new Object[]{key, value, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction setBinary(String key, Buffer value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SET, RedisClientStub.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction setBinaryWithOptions(String key, Buffer value, SetOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SET, RedisClientStub.toPayload(new Object[]{key, value, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction setbit(String key, long offset, int bit, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SETBIT, RedisClientStub.toPayload(new Object[]{key, offset, bit}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SETEX, RedisClientStub.toPayload(new Object[]{key, seconds, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction setnx(String key, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SETNX, RedisClientStub.toPayload(new Object[]{key, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction setrange(String key, int offset, String value, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SETRANGE, RedisClientStub.toPayload(new Object[]{key, offset, value}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction sinter(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SINTER, RedisClientStub.toPayload(new Object[]{keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction sinterstore(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SINTERSTORE, RedisClientStub.toPayload(new Object[]{destkey, keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction sismember(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SISMEMBER, RedisClientStub.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction slaveof(String host, int port, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SLAVEOF, RedisClientStub.toPayload(new Object[]{host, port}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction slaveofNoone(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SLAVEOF, RedisClientStub.toPayload(new Object[]{"NO", "ONE"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction slowlogGet(int limit, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SLOWLOG, RedisClientStub.toPayload(new Object[]{"GET", limit < 0 ? null : Integer.valueOf(limit)}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction slowlogLen(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SLOWLOG, RedisClientStub.toPayload(new Object[]{"LEN"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction slowlogReset(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SLOWLOG, RedisClientStub.toPayload(new Object[]{"RESET"}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction smembers(String key, Handler<AsyncResult<JsonArray>> handler) {
            RedisClientStub.this.sendJsonArray(Command.SMEMBERS, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<JsonArray>>)handler);
            return this;
        }

        public RedisTransaction smove(String key, String destkey, String member, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SMOVE, RedisClientStub.toPayload(new Object[]{key, destkey, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction sort(String key, SortOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SORT, RedisClientStub.toPayload(new Object[]{key, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction spop(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SPOP, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction spopMany(String key, int count, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SPOP, RedisClientStub.toPayload(new Object[]{key, count}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction srandmember(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SRANDMEMBER, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction srandmemberCount(String key, int count, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SRANDMEMBER, RedisClientStub.toPayload(new Object[]{key, count}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction srem(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SREM, RedisClientStub.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction sremMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SREM, RedisClientStub.toPayload(new Object[]{key, members}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction strlen(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.STRLEN, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction subscribe(String channel, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SUBSCRIBE, RedisClientStub.toPayload(new Object[]{channel}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction subscribeMany(List<String> channels, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SUBSCRIBE, RedisClientStub.toPayload(new Object[]{channels}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction sunion(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SUNION, RedisClientStub.toPayload(new Object[]{keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction sunionstore(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SUNIONSTORE, RedisClientStub.toPayload(new Object[]{destkey, keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction sync(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SYNC, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction time(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.TIME, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction ttl(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.TTL, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction type(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.TYPE, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction unsubscribe(List<String> channels, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.UNSUBSCRIBE, RedisClientStub.toPayload(new Object[]{channels}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction unwatch(Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.UNWATCH, null, (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.WAIT, RedisClientStub.toPayload(new Object[]{numSlaves, timeout}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction watch(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.WATCH, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction watchMany(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.WATCH, RedisClientStub.toPayload(new Object[]{keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zadd(String key, double score, String member, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZADD, RedisClientStub.toPayload(new Object[]{key, score, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        /*
         * Exception decompiling
         */
        public RedisTransaction zaddMany(String key, Map<String, Double> members, Handler<AsyncResult<String>> handler) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public RedisTransaction zcard(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZCARD, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zcount(String key, double min, double max, Handler<AsyncResult<String>> handler) {
            String minVal = min == Double.NEGATIVE_INFINITY ? "-inf" : String.valueOf(min);
            String maxVal = max == Double.POSITIVE_INFINITY ? "+inf" : String.valueOf(max);
            RedisClientStub.this.sendString(Command.ZCOUNT, RedisClientStub.toPayload(new Object[]{key, minVal, maxVal}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZINCRBY, RedisClientStub.toPayload(new Object[]{key, increment, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZINTERSTORE, RedisClientStub.toPayload(new Object[]{destkey, sets.size(), sets, options != null ? options.name() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZINTERSTORE, RedisClientStub.toPayload(new Object[]{destkey, sets.size(), sets.keySet(), "WEIGHTS", sets.values(), options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zlexcount(String key, String min, String max, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZLEXCOUNT, RedisClientStub.toPayload(new Object[]{key, min, max}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zrange(String key, long start, long stop, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZRANGE, RedisClientStub.toPayload(new Object[]{key, start, stop}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZRANGE, RedisClientStub.toPayload(new Object[]{key, start, stop, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZRANGEBYLEX, RedisClientStub.toPayload(new Object[]{key, min, max, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZRANGEBYSCORE, RedisClientStub.toPayload(new Object[]{key, min, max, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zrank(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZRANK, RedisClientStub.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zrem(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZREM, RedisClientStub.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zremMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZREM, RedisClientStub.toPayload(new Object[]{key, members}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zremrangebylex(String key, String min, String max, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZREMRANGEBYLEX, RedisClientStub.toPayload(new Object[]{key, min, max}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZREMRANGEBYRANK, RedisClientStub.toPayload(new Object[]{key, start, stop}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zremrangebyscore(String key, String min, String max, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZREMRANGEBYSCORE, RedisClientStub.toPayload(new Object[]{key, min, max}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZREVRANGE, RedisClientStub.toPayload(new Object[]{key, start, stop, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZREVRANGEBYLEX, RedisClientStub.toPayload(new Object[]{key, max, min, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZREVRANGEBYSCORE, RedisClientStub.toPayload(new Object[]{key, max, min, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zrevrank(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZREVRANK, RedisClientStub.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zscore(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZSCORE, RedisClientStub.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZUNIONSTORE, RedisClientStub.toPayload(new Object[]{destkey, sets.size(), sets, options != null ? options.name() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zunionstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZUNIONSTORE, RedisClientStub.toPayload(new Object[]{destkey, sets.size(), sets.keySet(), "WEIGHTS", sets.values(), options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction scan(String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SCAN, RedisClientStub.toPayload(new Object[]{cursor, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SSCAN, RedisClientStub.toPayload(new Object[]{key, cursor, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.HSCAN, RedisClientStub.toPayload(new Object[]{key, cursor, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.ZSCAN, RedisClientStub.toPayload(new Object[]{key, cursor, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GEOADD, RedisClientStub.toPayload(new Object[]{key, longitude, latitude, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GEOADD, RedisClientStub.toPayload(new Object[]{key, members}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction geohash(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GEOHASH, RedisClientStub.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction geohashMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GEOHASH, RedisClientStub.toPayload(new Object[]{key, members}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction geopos(String key, String member, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GEOPOS, RedisClientStub.toPayload(new Object[]{key, member}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction geoposMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GEOPOS, RedisClientStub.toPayload(new Object[]{key, members}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GEODIST, RedisClientStub.toPayload(new Object[]{key, member1, member2}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GEODIST, RedisClientStub.toPayload(new Object[]{key, member1, member2, unit}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GEORADIUS, RedisClientStub.toPayload(new Object[]{key, longitude, latitude, radius, unit}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GEORADIUS, RedisClientStub.toPayload(new Object[]{key, longitude, latitude, radius, unit, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GEORADIUSBYMEMBER, RedisClientStub.toPayload(new Object[]{key, member, radius, unit}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.GEORADIUSBYMEMBER, RedisClientStub.toPayload(new Object[]{key, member, radius, unit, options != null ? options.toJsonArray() : null}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction unlink(String key, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.UNLINK, RedisClientStub.toPayload(new Object[]{key}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction unlinkMany(List<String> keys, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.UNLINK, RedisClientStub.toPayload(new Object[]{keys}), (Handler<AsyncResult<String>>)handler);
            return this;
        }

        public RedisTransaction swapdb(int index1, int index2, Handler<AsyncResult<String>> handler) {
            RedisClientStub.this.sendString(Command.SWAPDB, RedisClientStub.toPayload(new Object[]{index1, index2}), (Handler<AsyncResult<String>>)handler);
            return this;
        }
    }
}

