/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.api;

import cn.vertxup.ui.service.ControlStub;
import cn.vertxup.ui.service.FormStub;
import cn.vertxup.ui.service.ListStub;
import cn.vertxup.ui.service.PageStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ui.cv.em.ControlType;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import javax.inject.Inject;

@Queue
public class UiActor {
    @Inject
    private transient PageStub stub;
    @Inject
    private transient ListStub listStub;
    @Inject
    private transient FormStub formStub;
    @Inject
    private transient ControlStub controlStub;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b1\u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03b7 \u03c7\u03c1\u03ae\u03c3\u03c4\u03b7/X-PAGE/AMP")
    public Future<JsonObject> fetchAmp(String sigma, JsonObject body) {
        return this.stub.fetchAmp(sigma, body);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b1\u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03b7 \u03c7\u03c1\u03ae\u03c3\u03c4\u03b7/X-CONTROL/BY-ID")
    public Future<JsonObject> fetchControl(JsonObject body) {
        String control = body.getString("control");
        ControlType type = (ControlType)Ut.toEnum(() -> body.getString("type"), ControlType.class, (Enum)ControlType.NONE);
        if (Ut.notNil((String)control)) {
            if (ControlType.LIST == type) {
                return this.listStub.fetchById(control);
            }
            return this.formStub.fetchById(control);
        }
        return Ux.fnJObject((Object)new JsonObject());
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b1\u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03b7 \u03c7\u03c1\u03ae\u03c3\u03c4\u03b7/X-OP/BY-ID")
    public Future<JsonArray> fetchOps(JsonObject body) {
        String control = body.getString("control");
        return this.controlStub.fetchOps(control);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b1\u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03b7 \u03c7\u03c1\u03ae\u03c3\u03c4\u03b7/X-FORM/BY-CODE")
    public Future<JsonObject> fetchForm(String sigma, String code) {
        return this.formStub.fetchByCode(code, sigma);
    }
}

