/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.service;

import cn.vertxup.ui.domain.tables.daos.UiFormDao;
import cn.vertxup.ui.service.FieldStub;
import cn.vertxup.ui.service.FormStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import javax.inject.Inject;

public class FormService
implements FormStub {
    private static final Annal LOGGER = Annal.get(FormService.class);
    @Inject
    private transient FieldStub fieldStub;

    @Override
    public Future<JsonObject> fetchById(String formId) {
        return Ux.Jooq.on(UiFormDao.class).findByIdAsync((Object)formId).compose(form -> {
            if (Objects.isNull(form)) {
                Ui.infoWarn(LOGGER, " Form not found, id = {0}", formId);
                return Ux.future((Object)new JsonObject());
            }
            JsonObject formJson = (JsonObject)Ut.serializeJson((Object)form);
            return this.attachConfig(formJson);
        });
    }

    @Override
    public Future<JsonObject> fetchByCode(String code, String sigma) {
        JsonObject filters = new JsonObject();
        filters.put("code", code);
        filters.put("sigma", sigma);
        filters.put("", Boolean.TRUE);
        return Ux.Jooq.on(UiFormDao.class).fetchOneAsync(filters).compose(form -> {
            if (Objects.isNull(form)) {
                Ui.infoWarn(LOGGER, " Form not found, code = {0}, sigma = {1}", code, sigma);
                return Ux.future((Object)new JsonObject());
            }
            JsonObject formJson = (JsonObject)Ut.serializeJson((Object)form);
            return this.attachConfig(formJson).compose(config -> Ux.future((Object)config.getJsonObject("form")));
        });
    }

    private Future<JsonObject> attachConfig(JsonObject formJson) {
        JsonObject metadata;
        JsonObject config = new JsonObject();
        Ke.mount((JsonObject)formJson, (String)"metadata");
        JsonObject form = new JsonObject();
        form.put("window", formJson.getValue("window"));
        form.put("columns", formJson.getValue("columns"));
        if (formJson.containsKey("className")) {
            form.put("className", formJson.getValue("className"));
        }
        if (formJson.containsKey("hidden")) {
            form.put("hidden", formJson.getValue("hidden"));
            Ke.mountArray((JsonObject)form, (String)"hidden");
        }
        if (formJson.containsKey("row")) {
            form.put("row", formJson.getValue("hidden"));
            Ke.mount((JsonObject)form, (String)"row");
        }
        if (formJson.containsKey("metadata") && (metadata = formJson.getJsonObject("metadata")).containsKey("initial")) {
            form.put("initial", metadata.getJsonObject("initial"));
        }
        String formId = formJson.getString("key");
        return this.fieldStub.fetchUi(formId).compose(ui -> Ux.future((Object)config.put("form", form.put("ui", ui))));
    }
}

