/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.service;

import cn.vertxup.ui.domain.tables.daos.UiListDao;
import cn.vertxup.ui.service.ListStub;
import cn.vertxup.ui.service.OptionStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import javax.inject.Inject;

public class ListService
implements ListStub {
    private static final Annal LOGGER = Annal.get(ListService.class);
    @Inject
    private transient OptionStub optionStub;

    @Override
    public Future<JsonObject> fetchById(String listId) {
        return Ux.Jooq.on(UiListDao.class).findByIdAsync((Object)listId).compose(list -> {
            if (Objects.isNull(list)) {
                Ui.infoWarn(LOGGER, " Form not found, id = {0}", listId);
                return Ux.future((Object)new JsonObject());
            }
            JsonObject listJson = (JsonObject)Ut.serializeJson((Object)list);
            return this.attachConfig(listJson);
        });
    }

    private Future<JsonObject> attachConfig(JsonObject listJson) {
        Ke.mount((JsonObject)listJson, (String)"options");
        Ke.mount((JsonObject)listJson, (String)"optionsAjax");
        Ke.mount((JsonObject)listJson, (String)"optionsSubmit");
        Ke.mount((JsonObject)listJson, (String)"vSegment");
        return Ux.future((Object)listJson).compose(Ux.applyMount((String)"vQuery", this.optionStub::fetchQuery)).compose(Ux.applyMount((String)"vSearch", this.optionStub::fetchSearch)).compose(Ux.applyMount((String)"vTable", this.optionStub::fetchTable)).compose(Ux.applyMountJson((String)"vSegment", this.optionStub::fetchFragment)).compose(Ke.fabricAsync((String)"classCombiner"));
    }
}

