/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ui.uca;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.optic.UiFabric;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;

public class ListCombiner
implements UiFabric {
    public Future<JsonObject> combine(JsonObject input) {
        JsonObject optionSubmit;
        JsonObject optionAjax;
        JsonObject normalized = new JsonObject();
        JsonObject query = input.getJsonObject("vQuery");
        if (Ut.notNil((JsonObject)query)) {
            normalized.put("query", Ui.optQuery(query));
        }
        JsonObject options = new JsonObject();
        JsonObject search = input.getJsonObject("vSearch");
        if (Ut.notNil((JsonObject)search)) {
            JsonObject processed = Ui.optSearch(search);
            options.mergeIn(processed, true);
        }
        options.put("dynamic.op", Boolean.TRUE);
        options.put("dynamic.switch", input.getBoolean("dynamicSwitch"));
        options.put("dynamic.column", input.getBoolean("dynamicColumn"));
        JsonObject commonOpts = input.getJsonObject("options");
        if (Ut.notNil((JsonObject)commonOpts)) {
            options.mergeIn(commonOpts.copy(), true);
        }
        if (Ut.notNil((JsonObject)(optionAjax = input.getJsonObject("optionsAjax")))) {
            options.mergeIn(optionAjax.copy(), true);
        }
        if (Ut.notNil((JsonObject)(optionSubmit = input.getJsonObject("optionsSubmit")))) {
            options.mergeIn(optionSubmit.copy(), true);
        }
        JsonObject fragment = input.getJsonObject("vSegment");
        JsonObject component = new JsonObject();
        fragment.fieldNames().forEach(field -> {
            JsonObject fragmentJson = fragment.getJsonObject(field);
            if (Ut.notNil((JsonObject)fragmentJson)) {
                JsonObject config = Ui.optFragment(fragmentJson);
                component.put(field, config);
                String opKey = "window." + field;
                options.put(opKey, fragmentJson.getValue("container"));
            }
        });
        normalized.put("options", options);
        normalized.put("component", component);
        JsonObject table = input.getJsonObject("vTable");
        if (Ut.notNil((JsonObject)table)) {
            normalized.put("table", Ui.optTable(table));
        }
        return Ux.future((Object)normalized);
    }
}

