/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.service;

import cn.vertxup.ui.domain.tables.daos.UiFieldDao;
import cn.vertxup.ui.domain.tables.pojos.UiField;
import cn.vertxup.ui.service.FieldStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.ui.cv.em.RowType;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class FieldService
implements FieldStub {
    private static final Annal LOGGER = Annal.get(FieldService.class);

    @Override
    public Future<JsonArray> fetchUi(String formId) {
        return Ux.Jooq.on(UiFieldDao.class).fetchAsync("controlId", (Object)formId).compose(ui -> {
            if (Objects.isNull(ui) || ui.isEmpty()) {
                Ui.infoWarn(LOGGER, " Field not configured.", new Object[0]);
                return Ux.future((Object)new JsonArray());
            }
            JsonArray uiJson = (JsonArray)Ut.serializeJson((Object)ui);
            return this.attachConfig(uiJson);
        });
    }

    @Override
    public Future<JsonArray> updateA(String controlId, JsonArray data) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        List fields = Ut.itJArray((JsonArray)data).filter(item -> !item.containsKey("name") || Ut.notNil((String)item.getString("name")) && null == seen.putIfAbsent(item.getString("name"), Boolean.TRUE)).map(this::mountIn).map(field -> field.put("controlId", Optional.ofNullable(field.getString("controlId")).orElse(controlId))).map(field -> (UiField)Ux.fromJson((JsonObject)field, UiField.class)).collect(Collectors.toList());
        return this.deleteByControlId(controlId).compose(result -> Ux.Jooq.on(UiFieldDao.class).insertAsync(fields).compose(Ux::fnJArray).compose(updatedFields -> {
            List list = Ut.itJArray((JsonArray)updatedFields).map(this::mountOut).collect(Collectors.toList());
            return Ux.future((Object)new JsonArray(list));
        }));
    }

    @Override
    public Future<Boolean> deleteByControlId(String controlId) {
        return Ux.Jooq.on(UiFieldDao.class).deleteAsync(new JsonObject().put("controlId", controlId));
    }

    private Future<JsonArray> attachConfig(JsonArray fieldJson) {
        JsonArray ui = new JsonArray();
        int rowIndex = Ut.itJArray((JsonArray)fieldJson).map(each -> each.getInteger("yPoint")).max(Comparator.naturalOrder()).orElse(0);
        for (int idx = 0; idx <= rowIndex; ++idx) {
            Integer current = idx;
            List<JsonObject> row = Ut.itJArray((JsonArray)fieldJson).filter(item -> current.equals(item.getInteger("yPoint"))).sorted(Comparator.comparing(item -> item.getInteger("xPoint"))).collect(Collectors.toList());
            JsonArray rowArr = new JsonArray();
            row.forEach(cell -> {
                RowType rowType = (RowType)Ut.toEnum(() -> cell.getString("rowType"), RowType.class, (Enum)RowType.FIELD);
                JsonObject dataCell = new JsonObject();
                if (RowType.TITLE == rowType) {
                    dataCell.put("title", cell.getValue("label"));
                    dataCell.put("field", cell.getValue("key"));
                } else if (RowType.CONTAINER == rowType) {
                    dataCell.put("complex", Boolean.TRUE);
                    dataCell.put("name", cell.getValue("container"));
                    Ke.mount((JsonObject)cell, (String)"optionJsx");
                    if (Objects.nonNull(cell.getValue("optionJsx"))) {
                        dataCell.put("config", cell.getValue("optionJsx"));
                    }
                } else {
                    Object format;
                    JsonObject config;
                    JsonObject optionJsx;
                    JsonArray rules;
                    Ke.mount((JsonObject)cell, (String)"optionJsx");
                    Ke.mount((JsonObject)cell, (String)"optionConfig");
                    Ke.mount((JsonObject)cell, (String)"optionItem");
                    Ke.mountArray((JsonObject)cell, (String)"rules");
                    String render = Objects.isNull(cell.getString("render")) ? "" : cell.getString("render");
                    String label = Objects.isNull(cell.getString("label")) ? "" : cell.getString("label");
                    String metadata = cell.getString("name") + "," + label + "," + cell.getInteger("span") + ",," + render;
                    dataCell.put("metadata", metadata);
                    Boolean hidden = cell.getBoolean("hidden");
                    if (hidden.booleanValue()) {
                        dataCell.put("hidden", Boolean.TRUE);
                    }
                    if (Objects.nonNull(rules = cell.getJsonArray("rules")) && !rules.isEmpty()) {
                        dataCell.put("optionConfig.rules", rules);
                    }
                    if (Objects.nonNull(cell.getValue("optionJsx"))) {
                        dataCell.put("optionJsx", cell.getValue("optionJsx"));
                    }
                    if (Objects.nonNull(cell.getValue("optionConfig"))) {
                        dataCell.put("optionConfig", cell.getValue("optionConfig"));
                    }
                    if (Objects.nonNull(cell.getValue("optionItem"))) {
                        dataCell.put("optionItem", cell.getValue("optionItem"));
                    }
                    if (Ut.notNil((JsonObject)(optionJsx = cell.getJsonObject("optionJsx"))) && Ut.notNil((JsonObject)(config = optionJsx.getJsonObject("config"))) && config.containsKey("format") && String.class == (format = config.getValue("format")).getClass()) {
                        dataCell.put("moment", Boolean.valueOf(true));
                    }
                }
                rowArr.add(dataCell);
            });
            ui.add(rowArr);
        }
        return Ux.future((Object)ui);
    }

    private JsonObject mountIn(JsonObject data) {
        Ke.mountString((JsonObject)data, (String)"optionJsx");
        Ke.mountString((JsonObject)data, (String)"optionConfig");
        Ke.mountString((JsonObject)data, (String)"optionItem");
        Ke.mountString((JsonObject)data, (String)"rules");
        Ke.mountString((JsonObject)data, (String)"metadata");
        return data;
    }

    private JsonObject mountOut(JsonObject data) {
        Ke.mount((JsonObject)data, (String)"optionJsx");
        Ke.mount((JsonObject)data, (String)"optionConfig");
        Ke.mount((JsonObject)data, (String)"optionItem");
        Ke.mountArray((JsonObject)data, (String)"rules");
        Ke.mount((JsonObject)data, (String)"metadata");
        return data;
    }
}

