/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.service;

import cn.vertxup.ui.domain.tables.daos.UiFormDao;
import cn.vertxup.ui.domain.tables.pojos.UiForm;
import cn.vertxup.ui.service.FieldStub;
import cn.vertxup.ui.service.FormStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import javax.inject.Inject;

public class FormService
implements FormStub {
    private static final Annal LOGGER = Annal.get(FormService.class);
    @Inject
    private transient FieldStub fieldStub;

    @Override
    public Future<JsonObject> fetchById(String formId) {
        return Ux.Jooq.on(UiFormDao.class).fetchByIdAsync((Object)formId).compose(form -> {
            if (Objects.isNull(form)) {
                Ui.infoWarn(LOGGER, " Form not found, id = {0}", formId);
                return Ux.future((Object)new JsonObject());
            }
            JsonObject formJson = (JsonObject)Ut.serializeJson((Object)form);
            return this.attachConfig(formJson);
        });
    }

    @Override
    public Future<JsonArray> fetchByIdentifier(String identifier, String sigma) {
        JsonObject condition = new JsonObject();
        condition.put("identifier", identifier);
        condition.put("sigma", sigma);
        return Ux.Jooq.on(UiFormDao.class).fetchAndAsync(condition).compose(Ux::futureA).compose(forms -> {
            Ut.itJArray((JsonArray)forms).forEach(form -> {
                Ke.mountArray((JsonObject)form, (String)"hidden");
                Ke.mount((JsonObject)form, (String)"metadata");
            });
            return Ux.future((Object)forms);
        });
    }

    @Override
    public Future<JsonObject> fetchByCode(String code, String sigma) {
        JsonObject filters = new JsonObject();
        filters.put("code", code);
        filters.put("sigma", sigma);
        filters.put("", Boolean.TRUE);
        return Ux.Jooq.on(UiFormDao.class).fetchOneAsync(filters).compose(form -> {
            if (Objects.isNull(form)) {
                Ui.infoWarn(LOGGER, " Form not found, code = {0}, sigma = {1}", code, sigma);
                return Ux.future((Object)new JsonObject());
            }
            JsonObject formJson = (JsonObject)Ut.serializeJson((Object)form);
            return this.attachConfig(formJson).compose(config -> Ux.future((Object)config.getJsonObject("form")));
        });
    }

    @Override
    public Future<JsonObject> update(String key, JsonObject data) {
        JsonObject form = this.mountIn(data);
        UiForm uiForm = (UiForm)Ux.fromJson((JsonObject)form, UiForm.class);
        return Ux.Jooq.on(UiFormDao.class).updateAsync((Object)key, (Object)uiForm).compose(Ux::futureJ).compose(updatedForm -> Ux.future((Object)this.mountOut((JsonObject)updatedForm)));
    }

    @Override
    public Future<Boolean> delete(String key) {
        return Ux.Jooq.on(UiFormDao.class).deleteByIdAsync((Object)key);
    }

    private Future<JsonObject> attachConfig(JsonObject formJson) {
        JsonObject metadata;
        JsonObject config = new JsonObject();
        Ke.mount((JsonObject)formJson, (String)"metadata");
        JsonObject form = new JsonObject();
        form.put("window", formJson.getValue("window"));
        form.put("columns", formJson.getValue("columns"));
        if (formJson.containsKey("className")) {
            form.put("className", formJson.getValue("className"));
        }
        if (formJson.containsKey("hidden")) {
            form.put("hidden", formJson.getValue("hidden"));
            Ke.mountArray((JsonObject)form, (String)"hidden");
        }
        if (formJson.containsKey("row")) {
            form.put("row", formJson.getValue("row"));
            Ke.mount((JsonObject)form, (String)"row");
        }
        if (formJson.containsKey("metadata") && (metadata = formJson.getJsonObject("metadata")).containsKey("initial")) {
            form.put("initial", metadata.getJsonObject("initial"));
        }
        String formId = formJson.getString("key");
        return this.fieldStub.fetchUi(formId).compose(ui -> Ux.future((Object)config.put("form", form.put("ui", ui))));
    }

    private JsonObject mountIn(JsonObject data) {
        Ke.mountString((JsonObject)data, (String)"hidden");
        Ke.mountString((JsonObject)data, (String)"row");
        Ke.mountString((JsonObject)data, (String)"metadata");
        return data;
    }

    private JsonObject mountOut(JsonObject data) {
        Ke.mountArray((JsonObject)data, (String)"hidden");
        Ke.mount((JsonObject)data, (String)"row");
        Ke.mount((JsonObject)data, (String)"metadata");
        return data;
    }
}

