/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.service;

import cn.vertxup.ui.domain.tables.daos.UiOpDao;
import cn.vertxup.ui.domain.tables.daos.VFragmentDao;
import cn.vertxup.ui.domain.tables.daos.VQueryDao;
import cn.vertxup.ui.domain.tables.daos.VSearchDao;
import cn.vertxup.ui.domain.tables.daos.VTableDao;
import cn.vertxup.ui.domain.tables.pojos.UiOp;
import cn.vertxup.ui.service.OptionStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class OptionService
implements OptionStub {
    @Override
    public Future<JsonObject> fetchQuery(String id) {
        return Ux.Jooq.on(VQueryDao.class).fetchByIdAsync((Object)id).compose(Ux::futureJ).compose(Ke.mount((String)"criteria")).compose(Ke.mountArray((String)"projection"));
    }

    @Override
    public Future<JsonObject> fetchSearch(String id) {
        return Ux.Jooq.on(VSearchDao.class).fetchByIdAsync((Object)id).compose(Ux::futureJ).compose(Ke.mount((String)"advancedNotice")).compose(Ke.mountArray((String)"cond"));
    }

    @Override
    public Future<JsonObject> fetchFragment(String id) {
        return Ux.Jooq.on(VFragmentDao.class).fetchByIdAsync((Object)id).compose(Ux::futureJ).compose(Ke.mount((String)"modal")).compose(Ke.mount((String)"notice")).compose(Ke.mount((String)"config")).compose(Ke.mountArray((String)"buttonGroup"));
    }

    @Override
    public Future<JsonObject> fetchTable(String id) {
        return Ux.Jooq.on(VTableDao.class).fetchByIdAsync((Object)id).compose(Ux::futureJ).compose(Ke.mountArray((String)"opConfig"));
    }

    @Override
    public Future<JsonArray> updateA(String controlId, JsonArray data) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        List ops = Ut.itJArray((JsonArray)data).filter(item -> Ut.notNil((String)item.getString("action")) && null == seen.putIfAbsent(item.getString("action"), Boolean.TRUE)).map(this::mountIn).map(field -> field.put("controlId", Optional.ofNullable(field.getString("controlId")).orElse(controlId))).map(field -> (UiOp)Ux.fromJson((JsonObject)field, UiOp.class)).collect(Collectors.toList());
        return this.deleteByControlId(controlId).compose(result -> Ux.Jooq.on(UiOpDao.class).insertAsync(ops).compose(Ux::futureA).compose(updatedOps -> {
            List list = Ut.itJArray((JsonArray)updatedOps).map(this::mountOut).collect(Collectors.toList());
            return Ux.future((Object)new JsonArray(list));
        }));
    }

    @Override
    public Future<Boolean> deleteByControlId(String controlId) {
        return Ux.Jooq.on(UiOpDao.class).deleteByAsync(new JsonObject().put("controlId", controlId));
    }

    private JsonObject mountIn(JsonObject data) {
        Ke.mountString((JsonObject)data, (String)"config");
        Ke.mountString((JsonObject)data, (String)"plugin");
        Ke.mountString((JsonObject)data, (String)"metadata");
        return data;
    }

    private JsonObject mountOut(JsonObject data) {
        Ke.mount((JsonObject)data, (String)"config");
        Ke.mount((JsonObject)data, (String)"plugin");
        Ke.mount((JsonObject)data, (String)"metadata");
        return data;
    }
}

