/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.service.column;

import cn.vertxup.ui.domain.tables.daos.UiColumnDao;
import cn.vertxup.ui.domain.tables.pojos.UiColumn;
import cn.vertxup.ui.service.column.UiValve;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.unity.Ux;
import java.util.Comparator;
import java.util.stream.Collectors;

class StoreValve
implements UiValve {
    StoreValve() {
    }

    @Override
    public Future<JsonArray> fetchColumn(String view, String identifier, String sigma) {
        String controlId = view + "-" + identifier;
        JsonObject filters = new JsonObject();
        filters.put("", Boolean.TRUE);
        filters.put("controlId", controlId);
        filters.put("sigma", sigma);
        return Ux.Jooq.on(UiColumnDao.class).fetchAsync(filters).compose(list -> Ux.future(list.stream().sorted(Comparator.comparing(UiColumn::getPosition)).collect(Collectors.toList()))).compose(list -> Ux.future(list.stream().map(this::procColumn).collect(Collectors.toList()))).compose(jsonList -> Ux.future((Object)new JsonArray(jsonList)));
    }

    private JsonObject procColumn(UiColumn column) {
        JsonObject columnJson = new JsonObject();
        columnJson.put("title", column.getTitle());
        columnJson.put("dataIndex", column.getDataIndex());
        Ke.runBoolean(column::getSorter, sorter -> columnJson.put("sorter", sorter));
        Ke.runBoolean(column::getFixed, fixed -> {
            if (fixed.booleanValue()) {
                columnJson.put("fixed", "left");
            } else {
                columnJson.put("fixed", "right");
            }
        });
        Ke.runString(column::getClassName, className -> columnJson.put("className", className));
        Ke.runInteger(column::getWidth, width -> columnJson.put("width", width));
        Ke.runString(column::getRender, render -> {
            columnJson.put("$render", render);
            if ("DATE".equals(render)) {
                assert (null != column.getFormat()) : " $format should not be null when DATE";
                columnJson.put("$format", column.getFormat());
            } else if ("DATUM".equals(render)) {
                assert (null != column.getDatum()) : " $datum should not be null when DATUM";
                columnJson.put("$datum", column.getDatum());
            }
        });
        Ke.runString(column::getFilterType, filterType -> {
            columnJson.put("$filter.type", filterType);
            columnJson.put("$filter.config", column.getFilterConfig());
            Ke.mount((JsonObject)columnJson, (String)"$filter.config");
        });
        Ke.runString(column::getEmpty, empty -> columnJson.put("$empty", empty));
        Ke.runString(column::getMapping, mapping -> {
            columnJson.put("$mapping", mapping);
            Ke.mount((JsonObject)columnJson, (String)"$mapping");
        });
        Ke.runString(column::getConfig, config -> {
            columnJson.put("$config", config);
            Ke.mount((JsonObject)columnJson, (String)"$config");
        });
        return columnJson;
    }
}

