/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ui.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ui.atom.UiJson;
import io.vertx.up.util.Ut;

class UiOption {
    UiOption() {
    }

    static JsonObject search(JsonObject search) {
        return UiJson.create(search.copy()).remove("key").convert("cond", "search.cond").convert("enabled", "search.enabled").convert("advanced", "search.advanced").convert("opRedo", "search.op.redo").convert("opAdvanced", "search.op.advanced").convert("confirmClear", "search.confirm.clear").convert("placeholder", "search.placeholder").convert("advancedWidth", "search.advanced.width").convert("advancedTitle", "search.advanced.title").convert("advancedNotice", "search.advanced.notice").to();
    }

    static JsonObject query(JsonObject query) {
        return UiJson.create(query.copy()).remove("key").to();
    }

    static JsonObject fragment(JsonObject input) {
        JsonObject fragment = UiJson.create(input.copy()).remove("key", "container", "config").convert("buttonConnect", "button").convert("buttonGroup", "buttons").to();
        JsonObject config = input.getJsonObject("config");
        if (Ut.notNil((JsonObject)config)) {
            fragment.mergeIn(config.copy(), true);
        }
        return fragment;
    }

    static JsonObject table(JsonObject table) {
        JsonObject tableJson = new JsonObject();
        JsonObject total = UiJson.create(table).pickupWith("total").convert("totalReport", "report").convert("totalSelected", "selected").to();
        tableJson.put("total", total);
        JsonObject row = UiJson.create(table).pickupWith("row").replaceWith("row", "on").to();
        tableJson.put("row", row);
        JsonObject column = UiJson.create(table).pickupWith("op").convert("opTitle", "title").convert("opDataIndex", "dataIndex").convert("opFixed", "fixed").convert("opConfig", "$option").add("$render", "EXECUTOR").to();
        tableJson.put("columns", new JsonArray().add(column));
        JsonObject rest = UiJson.create(table).removeWith("op").removeWith("total").removeWith("row").remove("key").to();
        tableJson.mergeIn(rest, true);
        return tableJson;
    }
}

