/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.service;

import cn.vertxup.ui.domain.tables.daos.UiListDao;
import cn.vertxup.ui.service.ListStub;
import cn.vertxup.ui.service.OptionStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import javax.inject.Inject;

public class ListService
implements ListStub {
    private static final Annal LOGGER = Annal.get(ListService.class);
    @Inject
    private transient OptionStub optionStub;

    @Override
    public Future<JsonObject> fetchById(String listId) {
        return Ux.Jooq.on(UiListDao.class).fetchByIdAsync((Object)listId).compose(list -> {
            if (Objects.isNull(list)) {
                Ui.infoWarn(LOGGER, " Form not found, id = {0}", listId);
                return Ux.future((Object)new JsonObject());
            }
            JsonObject listJson = (JsonObject)Ut.serializeJson((Object)list);
            return this.attachConfig(listJson);
        });
    }

    @Override
    public Future<JsonArray> fetchByIdentifier(String identifier, String sigma) {
        JsonObject condition = new JsonObject();
        condition.put("identifier", (Object)identifier);
        condition.put("sigma", (Object)sigma);
        return Ux.Jooq.on(UiListDao.class).fetchAndAsync(condition).compose(Ux::futureA);
    }

    private Future<JsonObject> attachConfig(JsonObject listJson) {
        Ut.ifJObject((JsonObject)listJson, (String[])new String[]{"options", "optionsAjax", "optionsSubmit", "vSegment"});
        return Ux.future((Object)listJson).compose(Ux.attach((String)"vQuery", this.optionStub::fetchQuery)).compose(Ux.attach((String)"vSearch", this.optionStub::fetchSearch)).compose(Ux.attach((String)"vTable", this.optionStub::fetchTable)).compose(Ux.attachJ((String)"vSegment", this.optionStub::fetchFragment)).compose(Ke.fabricAsync((String)"classCombiner"));
    }
}

