/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ui.init;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ui.atom.UiConfig;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class UiConfiguration {
    private static final Annal LOGGER = Annal.get(UiConfiguration.class);
    private static final ConcurrentMap<String, JsonArray> COLUMN_MAP = new ConcurrentHashMap<String, JsonArray>();
    private static UiConfig CONFIG = null;

    UiConfiguration() {
    }

    static void init() {
        if (null == CONFIG) {
            JsonObject uiData = Ut.ioJObject((String)"plugin/ui/configuration.json");
            Ui.infoInit(LOGGER, "Ui Json Data: {0}", uiData.encode());
            CONFIG = (UiConfig)Ut.deserialize((JsonObject)uiData, UiConfig.class);
            Ui.infoInit(LOGGER, "Ui Configuration: {0}", CONFIG.toString());
            UiConfiguration.initColumn(CONFIG);
            Ui.infoInit(LOGGER, "Ui Columns: Size = {0}", COLUMN_MAP.size());
        }
    }

    static UiConfig getConfig() {
        return CONFIG;
    }

    private static void initColumn(UiConfig config) {
        JsonObject mapping = config.getMapping();
        JsonObject combine = new JsonObject();
        if (Ut.notNil((JsonObject)mapping)) {
            combine.mergeIn(mapping, true);
        }
        String configPath = config.getDefinition();
        List files = Ut.ioFiles((String)configPath, (String)".json");
        files.forEach(file -> {
            String identifier = file.replace(".json", "");
            combine.put(identifier, file);
        });
        combine.fieldNames().forEach(fileKey -> {
            String file = combine.getString(fileKey);
            String filePath = configPath + "/" + file;
            JsonArray columns = Ut.ioJArray((String)filePath);
            if (Objects.nonNull(columns) && !columns.isEmpty()) {
                COLUMN_MAP.put((String)fileKey, columns);
            }
        });
        CONFIG.setMapping(combine);
    }

    static JsonArray getColumn(String key) {
        return COLUMN_MAP.getOrDefault(key, new JsonArray());
    }

    static JsonArray getOp() {
        return Ut.sureJArray((JsonArray)CONFIG.getOp());
    }

    static JsonArray attributes(String key) {
        JsonArray columns = UiConfiguration.getColumn(key);
        if (Ut.notNil((JsonArray)columns)) {
            ConcurrentHashMap<String, String> attributeMap = new ConcurrentHashMap<String, String>();
            Ut.itJArray((JsonArray)columns).forEach(json -> {
                if (json.containsKey("metadata")) {
                    String unparsed = json.getString("metadata");
                    String[] parsed = unparsed.split(",");
                    if (2 < parsed.length) {
                        String name = parsed[0];
                        String alias = parsed[1];
                        if (!Ut.isNilOr((String[])new String[]{name, alias})) {
                            attributeMap.put(name, alias);
                        }
                    }
                } else {
                    String name = json.getString("dataIndex");
                    String alias = json.getString("title");
                    if (!Ut.isNilOr((String[])new String[]{name, alias})) {
                        attributeMap.put(name, alias);
                    }
                }
            });
            JsonObject defaults = CONFIG.getAttributes();
            Ut.itJObject((JsonObject)defaults, (alias, name) -> {
                if (!attributeMap.containsKey(name)) {
                    attributeMap.put((String)name, (String)alias);
                }
            });
            JsonArray attributes = new JsonArray();
            attributeMap.forEach((name, alias) -> {
                JsonObject attribute = new JsonObject();
                attribute.put("name", name);
                attribute.put("alias", alias);
                attributes.add((Object)attribute);
            });
            return attributes;
        }
        return new JsonArray();
    }
}

