/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.service;

import cn.vertxup.ui.domain.tables.daos.UiFormDao;
import cn.vertxup.ui.domain.tables.pojos.UiForm;
import cn.vertxup.ui.service.FieldStub;
import cn.vertxup.ui.service.FormStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import javax.inject.Inject;

public class FormService
implements FormStub {
    private static final Annal LOGGER = Annal.get(FormService.class);
    @Inject
    private transient FieldStub fieldStub;

    @Override
    public Future<JsonObject> fetchById(String formId) {
        return Ux.Jooq.on(UiFormDao.class).fetchByIdAsync((Object)formId).compose(form -> {
            if (Objects.isNull(form)) {
                Ui.infoWarn(LOGGER, " Form not found, id = {0}", formId);
                return Ux.future((Object)new JsonObject());
            }
            JsonObject formJson = (JsonObject)Ut.serializeJson((Object)form);
            return this.attachConfig(formJson);
        });
    }

    @Override
    public Future<JsonArray> fetchByIdentifier(String identifier, String sigma) {
        JsonObject condition = new JsonObject();
        condition.put("identifier", (Object)identifier);
        condition.put("sigma", (Object)sigma);
        return Ux.Jooq.on(UiFormDao.class).fetchAndAsync(condition).compose(Ux::futureA).compose(Ut.ifJArray((String[])new String[]{"hidden", "metadata"}));
    }

    @Override
    public Future<JsonObject> fetchByCode(String code, String sigma) {
        JsonObject filters = new JsonObject();
        filters.put("code", (Object)code);
        filters.put("sigma", (Object)sigma);
        filters.put("", (Object)Boolean.TRUE);
        return Ux.Jooq.on(UiFormDao.class).fetchOneAsync(filters).compose(form -> {
            if (Objects.isNull(form)) {
                Ui.infoWarn(LOGGER, " Form not found, code = {0}, sigma = {1}", code, sigma);
                return Ux.future((Object)new JsonObject());
            }
            JsonObject formJson = (JsonObject)Ut.serializeJson((Object)form);
            return this.attachConfig(formJson).compose(config -> Ux.future((Object)config.getJsonObject("form")));
        });
    }

    @Override
    public Future<JsonObject> update(String key, JsonObject data) {
        JsonObject form = Ut.ifString((JsonObject)data, (String[])new String[]{"hidden", "row", "metadata"});
        UiForm uiForm = (UiForm)Ux.fromJson((JsonObject)form, UiForm.class);
        return Ux.Jooq.on(UiFormDao.class).updateAsync((Object)key, (Object)uiForm).compose(Ux::futureJ).compose(Ut.ifJObject((String[])new String[]{"hidden", "row", "metadata"}));
    }

    @Override
    public Future<Boolean> delete(String key) {
        return Ux.Jooq.on(UiFormDao.class).deleteByIdAsync((Object)key);
    }

    private Future<JsonObject> attachConfig(JsonObject formJson) {
        JsonObject metadata;
        JsonObject config = new JsonObject();
        Ut.ifJObject((JsonObject)formJson, (String[])new String[]{"metadata"});
        JsonObject form = new JsonObject();
        form.put("window", formJson.getValue("window"));
        form.put("columns", formJson.getValue("columns"));
        if (formJson.containsKey("className")) {
            form.put("className", formJson.getValue("className"));
        }
        if (formJson.containsKey("hidden")) {
            form.put("hidden", formJson.getValue("hidden"));
            Ut.ifJObject((JsonObject)form, (String[])new String[]{"hidden"});
        }
        if (formJson.containsKey("row")) {
            form.put("row", formJson.getValue("row"));
            Ut.ifJObject((JsonObject)form, (String[])new String[]{"row"});
        }
        if (formJson.containsKey("metadata") && (metadata = formJson.getJsonObject("metadata")).containsKey("initial")) {
            form.put("initial", (Object)metadata.getJsonObject("initial"));
        }
        String formId = formJson.getString("key");
        return this.fieldStub.fetchUi(formId).compose(ui -> Ux.future((Object)config.put("form", (Object)form.put("ui", ui))));
    }
}

