/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.service;

import cn.vertxup.ui.domain.tables.daos.UiLayoutDao;
import cn.vertxup.ui.domain.tables.daos.UiPageDao;
import cn.vertxup.ui.domain.tables.pojos.UiPage;
import cn.vertxup.ui.service.ControlStub;
import cn.vertxup.ui.service.PageStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.log.Debugger;
import io.vertx.up.uca.cache.Rapid;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;

public class PageService
implements PageStub {
    @Inject
    private transient ControlStub controlStub;

    @Override
    public Future<JsonObject> fetchLayout(String layoutId) {
        Function<String, Future> executor = layout -> Ux.Jooq.on(UiLayoutDao.class).fetchByIdAsync(layout).compose(Ux::futureJ).compose(Ut.ifJObject((String[])new String[]{"config"}));
        if (Debugger.onUiCache()) {
            return Rapid.t((String)"POOL_LAYOUT").cached((Object)layoutId, () -> (Future)executor.apply(layoutId));
        }
        return executor.apply(layoutId);
    }

    @Override
    public Future<JsonObject> fetchAmp(String sigma, JsonObject params) {
        JsonObject filters = params.copy();
        filters.put("sigma", (Object)sigma);
        filters.put("", (Object)Boolean.TRUE);
        return Ux.Jooq.on(UiPageDao.class).fetchOneAsync(filters).compose(page -> {
            if (Objects.nonNull(page)) {
                if (Ut.notNil((String)page.getLayoutId())) {
                    return this.fetchLayout((UiPage)page);
                }
                return Ux.futureJ((Object)page);
            }
            return Ux.future((Object)new JsonObject());
        }).compose(pageJson -> {
            String pageId = pageJson.getString("key");
            return this.controlStub.fetchControls(pageId).compose(controls -> {
                JsonObject converted = new JsonObject();
                controls.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).filter(item -> Objects.nonNull(item.getString("key"))).forEach(item -> converted.put(item.getString("key"), (Object)item.copy()));
                pageJson.put("controls", (Object)converted);
                return Ux.future((Object)pageJson);
            });
        });
    }

    private Future<JsonObject> fetchLayout(UiPage page) {
        return this.fetchLayout(page.getLayoutId()).compose(layout -> {
            JsonObject pageJson = Ux.toJson((Object)page);
            pageJson.put("layout", layout);
            return (Future)Ut.ifJObject((String[])new String[]{"containerConfig", "assist", "grid"}).apply(pageJson);
        });
    }
}

