/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.api;

import cn.vertxup.ui.service.FieldStub;
import cn.vertxup.ui.service.FormStub;
import cn.vertxup.ui.service.OptionStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import javax.inject.Inject;

@Queue
public class FormActor {
    private static final Annal LOGGER = Annal.get(FormActor.class);
    private final String FIELD_FIELDS = "fields";
    private final String FIELD_OPS = "ops";
    @Inject
    private transient FormStub formStub;
    @Inject
    private transient FieldStub fieldStub;
    @Inject
    private transient OptionStub optionStub;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b1\u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03b7 \u03c7\u03c1\u03ae\u03c3\u03c4\u03b7/X-FORM/PUT/CASCADE")
    public Future<JsonObject> putFormCascade(String key, JsonObject body) {
        JsonArray fields = body.getJsonArray("fields");
        JsonArray ops = body.getJsonArray("ops");
        Ui.infoUi(LOGGER, "putFormCascade updating data: {0}", body.encodePrettily());
        return this.formStub.update(key, body).compose(updatedForm -> this.fieldStub.updateA(key, fields)).compose(updatedFields -> {
            body.put("fields", updatedFields);
            return this.optionStub.updateA(key, ops);
        }).compose(updatedOps -> {
            body.put("ops", updatedOps);
            return Ux.future((Object)body);
        });
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b1\u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03b7 \u03c7\u03c1\u03ae\u03c3\u03c4\u03b7/X-FORM/DELETE")
    public Future<Boolean> deleteForm(String key) {
        return this.optionStub.deleteByControlId(key).compose(result -> this.fieldStub.deleteByControlId(key)).compose(result -> this.formStub.delete(key));
    }
}

