/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.service;

import cn.vertxup.ui.domain.tables.daos.UiControlDao;
import cn.vertxup.ui.domain.tables.daos.UiVisitorDao;
import cn.vertxup.ui.domain.tables.pojos.UiVisitor;
import cn.vertxup.ui.service.ControlStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.optic.ui.UiHunter;
import io.vertx.tp.ui.cv.em.ControlType;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.atom.unity.UData;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;

public class ControlService
implements ControlStub {
    private static final Annal LOGGER = Annal.get(ControlService.class);

    @Override
    public Future<JsonArray> fetchControls(String pageId) {
        return Ux.Jooq.on(UiControlDao.class).fetchAsync("pageId", (Object)pageId).compose(Ux::futureA).compose(list -> {
            JsonArray result = new JsonArray();
            list.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).map(item -> Ut.ifJObject((JsonObject)item, (String[])new String[]{"containerConfig", "componentConfig", "assist", "grid"})).forEach(arg_0 -> ((JsonArray)result).add(arg_0));
            return Ux.future((Object)result);
        });
    }

    @Override
    public Future<JsonObject> fetchById(String control) {
        return Ux.Jooq.on(UiControlDao.class).fetchByIdAsync((Object)control).compose(Ux::futureJ).compose(Ut.ifJObject((String[])new String[]{"containerConfig", "componentConfig", "assist", "grid"}));
    }

    @Override
    public Future<JsonObject> fetchControl(ControlType controlType, JsonObject params) {
        JsonObject criteria = Ux.whereAnd();
        criteria.put("type", (Object)controlType.name());
        Ut.elementCopy((JsonObject)criteria, (JsonObject)params, (String[])new String[]{"sigma", "identifier", "page", "path"});
        Ui.infoUi(LOGGER, "Control ( type = {0} ) with parameters = `{1}`", new Object[]{controlType, criteria.encode()});
        return Ux.Jooq.on(UiVisitorDao.class).fetchOneAsync(criteria).compose(visitor -> {
            if (Objects.isNull(visitor)) {
                return Ux.futureJ();
            }
            if (Ut.isNil((String)visitor.getControlId())) {
                String component = visitor.getRunComponent();
                if (Ut.isNil((String)component)) {
                    return Ux.futureJ();
                }
                Class clazz = Ut.clazz((String)component, null);
                if (Objects.isNull(clazz) || !Ut.isImplement((Class)clazz, UiHunter.class)) {
                    return Ux.futureJ();
                }
                UiHunter hunter = (UiHunter)Ut.instance((Class)clazz, (Object[])new Object[0]);
                UData data = UData.createJ((JsonObject)params);
                return hunter.seek(data, (UiVisitor)visitor).compose(controlId -> {
                    JsonObject response = Ux.toJson((Object)visitor);
                    response.put("controlId", controlId);
                    return Ux.future((Object)response);
                });
            }
            return Ux.futureJ((Object)visitor);
        });
    }
}

