/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.service;

import cn.vertxup.ui.domain.tables.daos.UiOpDao;
import cn.vertxup.ui.domain.tables.daos.VFragmentDao;
import cn.vertxup.ui.domain.tables.daos.VQueryDao;
import cn.vertxup.ui.domain.tables.daos.VSearchDao;
import cn.vertxup.ui.domain.tables.daos.VTableDao;
import cn.vertxup.ui.domain.tables.pojos.UiOp;
import cn.vertxup.ui.service.OptionStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class OptionService
implements OptionStub {
    @Override
    public Future<JsonObject> fetchQuery(String id) {
        return Ux.Jooq.on(VQueryDao.class).fetchByIdAsync((Object)id).compose(Ux::futureJ).compose(Ut.ifJObject((String[])new String[]{"criteria", "projection"}));
    }

    @Override
    public Future<JsonObject> fetchSearch(String id) {
        return Ux.Jooq.on(VSearchDao.class).fetchByIdAsync((Object)id).compose(Ux::futureJ).compose(Ut.ifJObject((String[])new String[]{"advancedNotice", "advancedView", "cond"}));
    }

    @Override
    public Future<JsonObject> fetchFragment(String id) {
        return Ux.Jooq.on(VFragmentDao.class).fetchByIdAsync((Object)id).compose(Ux::futureJ).compose(Ut.ifJObject((String[])new String[]{"modal", "notice", "config", "buttonGroup"}));
    }

    @Override
    public Future<JsonObject> fetchTable(String id) {
        return Ux.Jooq.on(VTableDao.class).fetchByIdAsync((Object)id).compose(Ux::futureJ).compose(Ut.ifJObject((String[])new String[]{"opConfig"}));
    }

    @Override
    public Future<JsonArray> updateA(String controlId, JsonArray data) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        List ops = Ut.itJArray((JsonArray)data).filter(item -> Ut.notNil((String)item.getString("action")) && null == seen.putIfAbsent(item.getString("action"), Boolean.TRUE)).map(item -> Ut.ifString((JsonObject)item, (String[])new String[]{"config", "plugin", "metadata"})).map(field -> field.put("controlId", (Object)Optional.ofNullable(field.getString("controlId")).orElse(controlId))).map(field -> (UiOp)Ux.fromJson((JsonObject)field, UiOp.class)).collect(Collectors.toList());
        return this.deleteByControlId(controlId).compose(result -> Ux.Jooq.on(UiOpDao.class).insertAsync(ops).compose(Ux::futureA).compose(Ut.ifJArray((String[])new String[]{"config", "plugin", "metadata"})));
    }

    @Override
    public Future<Boolean> deleteByControlId(String controlId) {
        return Ux.Jooq.on(UiOpDao.class).deleteByAsync(new JsonObject().put("controlId", (Object)controlId));
    }
}

