/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.api;

import cn.vertxup.ui.service.ControlStub;
import cn.vertxup.ui.service.DoStub;
import cn.vertxup.ui.service.FormStub;
import cn.vertxup.ui.service.ListStub;
import cn.vertxup.ui.service.PageStub;
import io.horizon.eon.em.container.ViewType;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ui.cv.em.ControlType;
import io.vertx.tp.ui.cv.em.OpType;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Me;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.config.XHeader;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import javax.inject.Inject;

@Queue
public class UiActor {
    @Inject
    private transient PageStub stub;
    @Inject
    private transient ListStub listStub;
    @Inject
    private transient DoStub doStub;
    @Inject
    private transient FormStub formStub;
    @Inject
    private transient ControlStub controlStub;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b1\u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03b7 \u03c7\u03c1\u03ae\u03c3\u03c4\u03b7/X-PAGE/AMP")
    public Future<JsonObject> fetchAmp(String sigma, JsonObject body) {
        return this.stub.fetchAmp(sigma, body);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b1\u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03b7 \u03c7\u03c1\u03ae\u03c3\u03c4\u03b7/X-CONTROL/BY-ID")
    public Future<JsonObject> fetchControl(JsonObject body) {
        return Ui.cacheControl(body, () -> {
            String control = body.getString("control");
            ControlType type = (ControlType)Ut.toEnum(() -> body.getString("type"), ControlType.class, (Enum)ControlType.NONE);
            if (Ut.isNotNil((String)control)) {
                if (ControlType.LIST == type) {
                    return this.listStub.fetchById(control);
                }
                return this.formStub.fetchById(control);
            }
            return Ux.futureJ((Object)new JsonObject());
        });
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b1\u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03b7 \u03c7\u03c1\u03ae\u03c3\u03c4\u03b7/X-OP/BY-ID")
    public Future<JsonArray> fetchOps(JsonObject body) {
        return Ui.cacheOps(body, () -> {
            String type = Ut.valueString((JsonObject)body, (String)"type");
            OpType opType = (OpType)Ut.toEnum(() -> type, OpType.class, null);
            if (Objects.isNull((Object)opType)) {
                return this.doStub.fetchSmart(body);
            }
            return switch (opType) {
                default -> throw new IncompatibleClassChangeError();
                case OpType.ATOM -> this.doStub.fetchAtom(body);
                case OpType.OP -> this.doStub.fetchWeb(body);
                case OpType.FLOW -> this.doStub.fetchFlow(body);
            };
        });
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b1\u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03b7 \u03c7\u03c1\u03ae\u03c3\u03c4\u03b7/X-FORM/BY-CODE")
    public Future<JsonObject> fetchForm(String sigma, String code) {
        return this.formStub.fetchByCode(code, sigma);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b1\u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03b7 \u03c7\u03c1\u03ae\u03c3\u03c4\u03b7/X-FORM/BY-IDENTIFIER")
    public Future<JsonArray> fetchForms(String sigma, String identifier) {
        return this.formStub.fetchByIdentifier(identifier, sigma);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b1\u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03b7 \u03c7\u03c1\u03ae\u03c3\u03c4\u03b7/X-LIST/BY-IDENTIFIER")
    public Future<JsonArray> fetchLists(String sigma, String identifier) {
        return this.listStub.fetchByIdentifier(identifier, sigma);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b1\u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03b7 \u03c7\u03c1\u03ae\u03c3\u03c4\u03b7/X-LIST-QR/BY/CODE")
    public Future<JsonArray> fetchListQr(String id, String position, String typeStr, XHeader header) {
        JsonObject condition = Ux.whereAnd().put("sigma", (Object)header.getSigma()).put("position", (Object)position);
        ViewType type = (ViewType)Ut.toEnum((String)typeStr, ViewType.class);
        if (ViewType.Model == type) {
            condition.put("identifier", (Object)id);
        } else {
            condition.put("workflow", (Object)id);
        }
        return this.listStub.fetchQr(condition);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u0394\u03b9\u03b1\u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03b7 \u03c7\u03c1\u03ae\u03c3\u03c4\u03b7/X-VISITOR/BY/IDENTIFIER")
    @Me
    public Future<JsonObject> fetchByVisitor(String page, String identifier, JsonObject params) {
        ControlType controlType = (ControlType)Ut.toEnum((String)params.getString("type"), ControlType.class);
        if (Objects.isNull((Object)controlType)) {
            return Ux.futureJ();
        }
        String view = params.getString("view", "DEFAULT");
        String alias = params.getString("alias", "DEFAULT");
        String position = params.getString("position", "DEFAULT");
        JsonObject request = new JsonObject();
        request.put("sigma", (Object)params.getString("sigma"));
        request.put("identifier", (Object)identifier);
        request.put("page", (Object)page);
        String path = view + "/" + position + "/" + alias;
        request.put("path", (Object)path);
        Ut.valueCopy((JsonObject)request, (JsonObject)params, (String[])new String[]{"data", "config"});
        return this.controlStub.fetchControl(controlType, request);
    }
}

