/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.service;

import cn.vertxup.ui.domain.tables.daos.UiFieldDao;
import cn.vertxup.ui.domain.tables.pojos.UiField;
import cn.vertxup.ui.service.FieldStub;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ui.cv.em.RowType;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class FieldService
implements FieldStub {
    private static final Annal LOGGER = Annal.get(FieldService.class);

    @Override
    public Future<JsonArray> fetchUi(String formId) {
        return Ux.Jooq.on(UiFieldDao.class).fetchAsync("controlId", (Object)formId).compose(ui -> {
            if (Objects.isNull(ui) || ui.isEmpty()) {
                Ui.LOG.Ui.warn(LOGGER, " Field not configured.", new Object[0]);
                return Ux.future((Object)new JsonArray());
            }
            JsonArray uiJson = (JsonArray)Ut.serializeJson((Object)ui);
            return this.attachConfig(uiJson);
        });
    }

    @Override
    public Future<JsonArray> updateA(String controlId, JsonArray data) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        List fields = Ut.itJArray((JsonArray)data).filter(item -> !item.containsKey("name") || Ut.isNotNil((String)item.getString("name")) && null == seen.putIfAbsent(item.getString("name"), Boolean.TRUE)).map(item -> Ut.valueToString((JsonObject)item, (String[])new String[]{"optionJsx", "optionConfig", "optionItem", "rules", "metadata"})).map(field -> field.put("controlId", (Object)Optional.ofNullable(field.getString("controlId")).orElse(controlId))).map(field -> (UiField)Ux.fromJson((JsonObject)field, UiField.class)).collect(Collectors.toList());
        return this.deleteByControlId(controlId).compose(result -> Ux.Jooq.on(UiFieldDao.class).insertAsync(fields).compose(Ux::futureA).compose(Fn.ofJArray((String[])new String[]{"optionJsx", "optionConfig", "optionItem", "rules", "metadata"})));
    }

    @Override
    public Future<Boolean> deleteByControlId(String controlId) {
        return Ux.Jooq.on(UiFieldDao.class).deleteByAsync(new JsonObject().put("controlId", (Object)controlId));
    }

    private Future<JsonArray> attachConfig(JsonArray fieldJson) {
        JsonArray ui = new JsonArray();
        int rowIndex = Ut.itJArray((JsonArray)fieldJson).map(each -> each.getInteger("yPoint")).max(Comparator.naturalOrder()).orElse(0);
        for (int idx = 0; idx <= rowIndex; ++idx) {
            Integer current = idx;
            List<JsonObject> row = Ut.itJArray((JsonArray)fieldJson).filter(item -> current.equals(item.getInteger("yPoint"))).sorted(Comparator.comparing(item -> item.getInteger("xPoint"))).toList();
            JsonArray rowArr = new JsonArray();
            row.forEach(cell -> {
                RowType rowType = (RowType)Ut.toEnum(() -> cell.getString("rowType"), RowType.class, (Enum)RowType.FIELD);
                JsonObject dataCell = new JsonObject();
                if (RowType.TITLE == rowType) {
                    dataCell.put("title", cell.getValue("label"));
                    dataCell.put("field", cell.getValue("key"));
                } else if (RowType.CONTAINER == rowType) {
                    dataCell.put("complex", (Object)Boolean.TRUE);
                    dataCell.put("name", cell.getValue("container"));
                    Ut.valueToJObject((JsonObject)cell, (String[])new String[]{"optionJsx"});
                    if (Objects.nonNull(cell.getValue("optionJsx"))) {
                        dataCell.put("config", cell.getValue("optionJsx"));
                    }
                } else {
                    Object format;
                    JsonObject config;
                    JsonObject optionJsx;
                    JsonArray rules;
                    Ut.valueToJObject((JsonObject)cell, (String[])new String[]{"optionJsx", "optionConfig", "optionItem", "rules"});
                    String render = Objects.isNull(cell.getString("render")) ? "" : cell.getString("render");
                    String label = Objects.isNull(cell.getString("label")) ? "" : cell.getString("label");
                    String metadata = cell.getString("name") + "," + label + "," + cell.getInteger("span") + ",," + render;
                    dataCell.put("metadata", (Object)metadata);
                    Boolean hidden = cell.getBoolean("hidden");
                    if (hidden.booleanValue()) {
                        dataCell.put("hidden", (Object)Boolean.TRUE);
                    }
                    if (Objects.nonNull(rules = cell.getJsonArray("rules")) && !rules.isEmpty()) {
                        dataCell.put("optionConfig.rules", (Object)rules);
                    }
                    if (Objects.nonNull(cell.getValue("optionJsx"))) {
                        dataCell.put("optionJsx", cell.getValue("optionJsx"));
                    }
                    if (Objects.nonNull(cell.getValue("optionConfig"))) {
                        dataCell.put("optionConfig", cell.getValue("optionConfig"));
                    }
                    if (Objects.nonNull(cell.getValue("optionItem"))) {
                        dataCell.put("optionItem", cell.getValue("optionItem"));
                    }
                    if (Ut.isNotNil((JsonObject)(optionJsx = cell.getJsonObject("optionJsx"))) && Ut.isNotNil((JsonObject)(config = optionJsx.getJsonObject("config"))) && config.containsKey("format") && String.class == (format = config.getValue("format")).getClass()) {
                        dataCell.put("moment", (Object)true);
                    }
                }
                rowArr.add((Object)dataCell);
            });
            ui.add((Object)rowArr);
        }
        return Ux.future((Object)ui);
    }
}

