/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.ui.service;

import cn.vertxup.ui.domain.tables.daos.UiListDao;
import cn.vertxup.ui.domain.tables.daos.UiViewDao;
import cn.vertxup.ui.service.ListStub;
import cn.vertxup.ui.service.OptionStub;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.tp.ui.uca.qbe.QBECache;
import io.vertx.up.atom.query.Sorter;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import javax.inject.Inject;

public class ListService
implements ListStub {
    private static final Annal LOGGER = Annal.get(ListService.class);
    @Inject
    private transient OptionStub optionStub;

    @Override
    public Future<JsonObject> fetchById(String listId) {
        return Ux.Jooq.on(UiListDao.class).fetchByIdAsync((Object)listId).compose(list -> {
            if (Objects.isNull(list)) {
                Ui.LOG.Ui.warn(LOGGER, " Form not found, id = {0}", new Object[]{listId});
                return Ux.future((Object)new JsonObject());
            }
            JsonObject listJson = (JsonObject)Ut.serializeJson((Object)list);
            return this.attachConfig(listJson);
        });
    }

    @Override
    public Future<JsonArray> fetchByIdentifier(String identifier, String sigma) {
        JsonObject condition = new JsonObject();
        condition.put("identifier", (Object)identifier);
        condition.put("sigma", (Object)sigma);
        return Ux.Jooq.on(UiListDao.class).fetchAndAsync(condition).compose(Ux::futureA);
    }

    @Override
    public Future<JsonArray> fetchQr(JsonObject condition) {
        Sorter sorter = Sorter.create((String)"sort", (Boolean)true);
        return Ux.Jooq.on(UiViewDao.class).fetchAsync(condition, sorter).compose(QBECache::cached).compose(Ux::futureA).compose(Ux.futureF((String[])new String[]{"criteria", "projection", "rows", "qrComponent", "qrConfig", "view", "position"}));
    }

    private Future<JsonObject> attachConfig(JsonObject listJson) {
        Ut.valueToJObject((JsonObject)listJson, (String[])new String[]{"options", "optionsAjax", "optionsSubmit", "vSegment"});
        return Ux.future((Object)listJson).compose(Fn.ofJObject((String)"vQuery", this.optionStub::fetchQuery)).compose(Fn.ofJObject((String)"vSearch", this.optionStub::fetchSearch)).compose(Fn.ofJObject((String)"vTable", this.optionStub::fetchTable)).compose(Fn.ofTree((String)"vSegment", this.optionStub::fetchFragment)).compose(Fn.ofWebUi((String)"classCombiner"));
    }
}

