/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ui.atom;

import io.vertx.core.json.JsonObject;
import io.vertx.up.util.Ut;
import java.util.Arrays;

public class UiJson {
    private transient JsonObject input;

    private UiJson(JsonObject input) {
        this.input = Ut.isNil((JsonObject)input) ? new JsonObject() : input.copy();
    }

    public static UiJson create(JsonObject input) {
        return new UiJson(input);
    }

    public UiJson add(String key, Object value) {
        this.input.put(key, value);
        return this;
    }

    public UiJson remove(String ... keys) {
        Arrays.stream(keys).forEach(arg_0 -> ((JsonObject)this.input).remove(arg_0));
        return this;
    }

    public UiJson removeWith(String prefix) {
        JsonObject processed = this.input.copy();
        processed.fieldNames().stream().filter(key -> key.startsWith(prefix)).forEach(arg_0 -> ((JsonObject)this.input).remove(arg_0));
        return this;
    }

    public UiJson pickup(String ... keys) {
        JsonObject processed = this.input.copy();
        this.input.clear();
        Arrays.stream(keys).forEach(key -> this.input.put(key, processed.getValue(key)));
        return this;
    }

    public UiJson pickupWith(String prefix) {
        JsonObject processed = this.input.copy();
        this.input.clear();
        processed.fieldNames().stream().filter(key -> key.startsWith(prefix)).forEach(key -> this.input.put(key, processed.getValue(key)));
        return this;
    }

    public UiJson convertChild(String from, String prefix) {
        JsonObject processed = this.input.copy();
        JsonObject item = processed.getJsonObject(from);
        if (Ut.isNotNil((JsonObject)item)) {
            item.fieldNames().stream().filter(field -> field.startsWith(prefix)).forEach(key -> this.input.put(key, item.getValue(key)));
        }
        this.input.remove(from);
        return this;
    }

    public UiJson replaceWith(String from, String to) {
        JsonObject processed = this.input.copy();
        this.input.clear();
        processed.fieldNames().stream().filter(key -> key.startsWith(from)).forEach(key -> {
            String replaced = key.replace(from, to);
            this.input.put(replaced, processed.getValue(key));
        });
        return this;
    }

    public UiJson convert(String from, String to) {
        if (this.input.containsKey(from)) {
            Object value = this.input.getValue(from);
            this.input.remove(from);
            this.input.put(to, value);
        }
        return this;
    }

    public JsonObject to() {
        JsonObject to = this.input.copy();
        this.input = null;
        return to;
    }
}

