/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ui.refine;

import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ui.init.UiPin;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.uca.cache.Rapid;
import io.vertx.up.util.Ut;
import java.util.function.Supplier;

class UiCache {
    private static final Annal LOGGER = Annal.get(UiCache.class);

    UiCache() {
    }

    public static Future<JsonObject> cacheControl(JsonObject body, Supplier<Future<JsonObject>> executor) {
        return UiCache.getCache(UiPin::keyControl, body, executor);
    }

    public static Future<JsonArray> cacheOps(JsonObject body, Supplier<Future<JsonArray>> executor) {
        return UiCache.getCache(UiPin::keyOps, body, executor);
    }

    private static <T> Future<T> getCache(Supplier<String> poolFn, JsonObject body, Supplier<Future<T>> executor) {
        String keyPool = poolFn.get();
        if (Ut.isNotNil((String)keyPool)) {
            String uiKey = String.valueOf(body.hashCode());
            return Rapid.t((String)keyPool).cached((Object)uiKey, executor);
        }
        Ui.LOG.Ui.info(LOGGER, "Ui Cached has been disabled!", new Object[0]);
        return executor.get();
    }
}

