/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ui.uca;

import io.horizon.spi.ui.UiControl;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;

public class ListCombiner
implements UiControl {
    public Future<JsonObject> combine(JsonObject input) {
        JsonObject optionSubmit;
        JsonObject optionAjax;
        JsonObject normalized = new JsonObject();
        JsonObject query = input.getJsonObject("vQuery");
        if (Ut.isNotNil((JsonObject)query)) {
            normalized.put("query", (Object)Ui.optQuery(query));
        }
        JsonObject options = new JsonObject();
        JsonObject search = input.getJsonObject("vSearch");
        if (Ut.isNotNil((JsonObject)search)) {
            JsonObject processed = Ui.optSearch(search);
            options.mergeIn(processed, true);
        }
        options.put("dynamic.op", (Object)Boolean.TRUE);
        options.put("dynamic.switch", (Object)input.getBoolean("dynamicSwitch"));
        options.put("dynamic.column", (Object)input.getBoolean("dynamicColumn"));
        JsonObject commonOpts = input.getJsonObject("options");
        if (Ut.isNotNil((JsonObject)commonOpts)) {
            options.mergeIn(commonOpts.copy(), true);
        }
        if (Ut.isNotNil((JsonObject)(optionAjax = input.getJsonObject("optionsAjax")))) {
            options.mergeIn(optionAjax.copy(), true);
        }
        if (Ut.isNotNil((JsonObject)(optionSubmit = input.getJsonObject("optionsSubmit")))) {
            options.mergeIn(optionSubmit.copy(), true);
        }
        JsonObject fragment = input.getJsonObject("vSegment");
        JsonObject component = new JsonObject();
        fragment.fieldNames().forEach(field -> {
            JsonObject fragmentJson = fragment.getJsonObject(field);
            if (Ut.isNotNil((JsonObject)fragmentJson)) {
                JsonObject config = Ui.optFragment(fragmentJson);
                component.put(field, (Object)config);
                String opKey = "window." + field;
                options.put(opKey, fragmentJson.getValue("container"));
            }
        });
        normalized.put("options", (Object)options);
        normalized.put("component", (Object)component);
        JsonObject table = input.getJsonObject("vTable");
        if (Ut.isNotNil((JsonObject)table)) {
            normalized.put("table", (Object)Ui.optTable(table));
        }
        return Ux.future((Object)normalized);
    }
}

