/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ui.uca.qbe;

import cn.vertxup.ui.domain.tables.pojos.UiView;
import io.horizon.cloud.query.HCond;
import io.horizon.uca.cache.Cc;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.cache.Rapid;
import io.vertx.up.unity.Ux;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class QBECache {
    public static final Cc<String, HCond> CCT_H_COND = Cc.openThread();
    private static final Rapid<String, UiView> RAPID = Rapid.t((String)"POOL_LIST_QR", (int)600);

    public static Future<List<UiView>> cached(List<UiView> listQr) {
        ArrayList futures = new ArrayList();
        listQr.forEach(qr -> {
            String key = qr.getSigma() + "/" + qr.getCode() + "/" + qr.getName();
            futures.add(RAPID.write((Object)key, qr).compose(v -> Ux.futureT()));
        });
        return Fn.combineT(futures).compose(done -> Ux.future((Object)listQr));
    }

    public static Future<UiView> cached(JsonObject qr, Supplier<Future<UiView>> executor) {
        String key = qr.getString("sigma") + "/" + qr.getString("code") + "/" + qr.getString("name");
        return RAPID.cached((Object)key, executor);
    }
}

