package io.vertx.tp.workflow.uca.component;

import cn.zeroup.macrocosm.cv.em.TodoStatus;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.*;
import io.vertx.tp.workflow.uca.modeling.Register;
import io.vertx.tp.workflow.uca.runner.IsOn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import org.camunda.bpm.engine.task.Task;

import java.util.Objects;
import java.util.function.Function;

/**
 * @author <a href="http://www.origin-x.cn">Lang</a>
 */
public class TransferStandard extends AbstractMovement implements Transfer {
    @Override
    public Future<WRecord> moveAsync(final JsonObject params, final WProcess wProcess) {
        /*
         * Capture the next task for standard workflow
         * 1. Here camunda-workflow task has been finished
         * 2. Check condition in workflow engine
         * -- 2.1. Active task is not end
         * -- 2.2. Next task is user task
         * */
        return this.inputAsync(params)


            /*
             * Entity / Extension Ticket Record Execution, ( Update )
             * Todo Updated with normalized
             * */
            .compose(normalized -> {
                /*
                 * Todo Data Only
                 */
                final JsonObject todoData = HelperTodo.closeJ(normalized, wProcess);
                return this.saveAsync(todoData, wProcess)
                    .compose(this.saveAsyncFn(normalized, wProcess));
            })


            /*
             * Trigger next todo generation here
             */
            .compose(record -> wProcess.next().compose(taskNext -> {
                /*
                 * Todo Generation Condition
                 * 1. Instance is not ended
                 * 2. Next task is UserEvent
                 */
                final IsOn is = IsOn.get();
                if (wProcess.isContinue() && is.isUserEvent(taskNext)) {
                    /*
                     * Create new WProcess based on process / task and move
                     *
                     * Here instance contains previous data such as:
                     * 1. Task
                     * 2. ConfigRunner is runConfig
                     * 3. ProcessInstance
                     *
                     * The WMove should be generated by
                     * 1. Previous task definition key
                     * 2. Data with
                     */
                    final WProcess instanceNext = WProcess.create();
                    {
                        final Task task = wProcess.task();
                        final WMove move = this.moveGet(task.getTaskDefinitionKey());
                        move.stored(params);
                        instanceNext.bind(taskNext).bind(move).bind(wProcess.instance());
                    }
                    return this.generateAsync(params, instanceNext, record);
                } else {
                    return Ux.future(record);
                }
            }));
    }

    private Function<WRecord, Future<WRecord>> saveAsyncFn(final JsonObject input, final WProcess process) {
        return record -> {
            /*
             * Double check for `insert record`
             * Here will execute twice on entity record instead of one
             * 1. Insert -> Move Update
             * 2. Update -> Move Update
             * The `status` should be previous status
             * - ADD -> Inserted Status
             * - UPDATE -> Original Stored Status
             */
            final TodoStatus status = record.status();
            JsonObject request = input.copy();
            request.mergeIn(record.data());
            final MetaInstance metadataOut = MetaInstance.output(record, this.metadataIn());
/*          if (TodoStatus.DRAFT == status) {
                return this.saveAsync(request, metadataOut).compose(nil -> Ux.future(record));
            } else */
            if (TodoStatus.PENDING == status) {
                /*
                 * Move Rules
                 */
                final WMoveRule moveRule = process.rule();
                if (Objects.nonNull(moveRule) && Ut.notNil(moveRule.getRecord())) {
                    /*
                     * Here will fetch record auto
                     * Critical step to update `record` field here
                     */
                    request = this.recordMove(request, moveRule);
                }
            }
            /*
             * Contains record modification, do update on record.
             */
            final Register register = Register.instance(request);
            return register.saveAsync(request, metadataOut).compose(nil -> Ux.future(record));
        };
    }
}
