/*
 * Decompiled with CFR 0.152.
 */
package cn.zeroup.macrocosm.api;

import cn.vertxup.workflow.domain.tables.daos.WTicketDao;
import cn.zeroup.macrocosm.service.CondStub;
import cn.zeroup.macrocosm.service.FlowStub;
import cn.zeroup.macrocosm.service.TaskStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.config.XHeader;
import io.vertx.up.unity.Ux;
import javax.inject.Inject;
import org.camunda.bpm.engine.repository.ProcessDefinition;

@Queue
public class QueueActor {
    @Inject
    private transient FlowStub flowStub;
    @Inject
    private transient TaskStub taskStub;
    @Inject
    private transient CondStub condStub;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03a1\u03bf\u03ae \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2/W-TODO/TASK/QUEUE")
    public Future<JsonObject> fetchQueue(JsonObject qr, User user) {
        String userId = Ux.keyUser((User)user);
        return this.condStub.qrQueue(qr, userId).compose(this.taskStub::fetchQueue);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03a1\u03bf\u03ae \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2/W-TICKET/TICKET/HISTORY")
    public Future<JsonObject> fetchHistory(JsonObject qr, User user) {
        String userId = Ux.keyUser((User)user);
        return this.condStub.qrHistory(qr, userId).compose(this.taskStub::fetchHistory);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03a1\u03bf\u03ae \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2/W-FLOW/BY/CODE")
    public Future<JsonObject> fetchFlow(String code, XHeader header) {
        String sigma = header.getSigma();
        return this.flowStub.fetchFlow(code, sigma);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03a1\u03bf\u03ae \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2/W-TODO/TASK/VIRTUAL-FORM")
    public Future<JsonObject> fetchForm(JsonObject data, Boolean isPre, XHeader header) {
        if (isPre.booleanValue()) {
            String definitionId = data.getString("definitionId");
            return Wf.processById(definitionId).compose(definition -> this.flowStub.fetchFormStart((ProcessDefinition)definition, header.getSigma()));
        }
        String instanceId = data.getString("instanceId");
        return Wf.instance(instanceId).compose(process -> {
            if (process.isRunning()) {
                return this.flowStub.fetchForm(process.definition(), process.instance(), header.getSigma());
            }
            return this.flowStub.fetchFormEnd(process.definition(), process.instanceFinished(), header.getSigma());
        });
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03a1\u03bf\u03ae \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2/W-FLOW/BY/KEY")
    public Future<JsonObject> fetchTodo(String key, User user) {
        String userId = Ux.keyUser((User)user);
        return this.taskStub.readPending(key, userId);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03a1\u03bf\u03ae \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2/W-FLOW/BY/HISTORY")
    public Future<JsonObject> fetchHistory(String key) {
        return this.taskStub.readFinished(key);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03a1\u03bf\u03ae \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2/W-TICKET/TICKET/LINKAGE")
    public Future<JsonObject> searchTicket(JsonObject query) {
        return Ux.Jooq.on(WTicketDao.class).searchAsync(query);
    }
}

