/*
 * Decompiled with CFR 0.152.
 */
package cn.zeroup.macrocosm.service;

import cn.zeroup.macrocosm.cv.em.TodoStatus;
import cn.zeroup.macrocosm.service.CondStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.up.unity.Ux;
import java.util.HashSet;
import java.util.Set;

public class CondService
implements CondStub {
    private static final Set<String> SKIP_QUEUE_SET = new HashSet<String>(){
        {
            this.add("owner");
            this.add("supervisor");
            this.add("openBy");
            this.add("toUser");
            this.add("toRole");
            this.add("toDept");
            this.add("toTeam");
            this.add("toGroup");
        }
    };
    private static final Set<String> SKIP_HISTORY_SET = new HashSet<String>(){
        {
            this.add("owner");
            this.add("supervisor");
            this.add("openBy");
            this.add("cancelBy");
            this.add("closeBy");
        }
    };

    @Override
    public Future<JsonObject> qrQueue(JsonObject qr, String user) {
        if (this.skipDefault(qr, SKIP_QUEUE_SET)) {
            Wf.Log.initQueue(this.getClass(), "Qr Skip: {0}", qr.encode());
            JsonObject qrStatus = Ux.whereAnd();
            qrStatus.put("status,i", (Object)new JsonArray().add((Object)TodoStatus.PENDING.name()).add((Object)TodoStatus.ACCEPTED.name()).add((Object)TodoStatus.DRAFT.name()));
            JsonObject qrCombine = Ux.whereQrA((JsonObject)qr, (String)"$Q$", (Object)qrStatus);
            Wf.Log.initQueue(this.getClass(), "Qr Queue ( Skip ): {0}", qrCombine.encode());
            return Ux.future((Object)qrCombine);
        }
        JsonObject qrQueue = Ux.whereOr();
        JsonObject qrCreate = Ux.whereAnd((String)"openBy", (Object)user).put("status,i", (Object)new JsonArray().add((Object)TodoStatus.PENDING.name()).add((Object)TodoStatus.ACCEPTED.name()).add((Object)TodoStatus.DRAFT.name()));
        qrQueue.put("$QrC$", (Object)qrCreate);
        JsonObject qrApprove = Ux.whereAnd((String)"toUser", (Object)user).put("status,i", (Object)new JsonArray().add((Object)TodoStatus.PENDING.name()));
        qrQueue.put("$QrA", (Object)qrApprove);
        JsonObject qrCombine = Ux.whereQrA((JsonObject)qr, (String)"$Q$", (Object)qrQueue);
        Wf.Log.initQueue(this.getClass(), "Qr Queue: {0}", qrCombine.encode());
        return Ux.future((Object)qrCombine);
    }

    @Override
    public Future<JsonObject> qrHistory(JsonObject qr, String user) {
        if (this.skipDefault(qr, SKIP_HISTORY_SET)) {
            Wf.Log.initQueue(this.getClass(), "Qr Skip: {0}", qr.encode());
            return Ux.future((Object)qr);
        }
        JsonObject qrHistory = Ux.whereOr((String)"openBy", (Object)user);
        qrHistory.put("owner", (Object)user);
        JsonObject qrCombine = Ux.whereQrA((JsonObject)qr, (String)"$Q$", (Object)qrHistory);
        Wf.Log.initQueue(this.getClass(), "Qr History: {0}", qrCombine.encode());
        return Ux.future((Object)qrCombine);
    }

    private boolean skipDefault(JsonObject qr, Set<String> skipSet) {
        JsonObject criteria = qr.getJsonObject("criteria", new JsonObject());
        long counter = criteria.fieldNames().stream().map(field -> {
            if (field.contains(",")) {
                return field.split(",")[0];
            }
            return field;
        }).filter(skipSet::contains).count();
        return 0L < counter;
    }
}

